/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.local;

import com.jeesuite.cache.local.ClearCommand;
import com.jeesuite.cache.local.GuavaLevel1CacheProvider;
import com.jeesuite.cache.local.Level1CacheProvider;
import com.jeesuite.spring.InstanceFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class Level1CacheSupport
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(Level1CacheSupport.class);
    private static String channelName = "clearLevel1Cache";
    private String servers;
    private boolean distributedMode = true;
    private String password;
    private List<String> cacheNames;
    private Jedis subJedisClient;
    private JedisPool pupJedisPool;
    private ScheduledExecutorService redisCheckTimer;
    private Level1CacheProvider cacheProvider;
    private LocalCacheSyncListener listener;
    private static Level1CacheSupport instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Level1CacheSupport getInstance() {
        if (instance != null) return instance;
        Class<Level1CacheSupport> clazz = Level1CacheSupport.class;
        synchronized (Level1CacheSupport.class) {
            if (instance == null) {
                instance = (Level1CacheSupport)InstanceFactory.getInstance(Level1CacheSupport.class);
            }
            if (instance != null) return instance;
            instance = new Level1CacheSupport();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean publishSyncEvent(String key) {
        if (this.cacheNames == null) {
            return true;
        }
        if (!this.distributedMode) {
            return true;
        }
        String cacheName = key.split("\\.")[0];
        if (!this.cacheNames.contains(cacheName)) {
            return true;
        }
        this.cacheProvider.remove(cacheName, key);
        logger.debug("redis publish:{} for key:{}", (Object)channelName, (Object)key);
        return this.publish(channelName, new ClearCommand(cacheName, key).serialize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean publish(String channel, String message) {
        try (Jedis jedis = null;){
            jedis = this.pupJedisPool.getResource();
            boolean bl = jedis.publish(channel, message) > 0L;
            return bl;
        }
    }

    public boolean set(String key, Object value) {
        if (this.cacheNames == null) {
            return true;
        }
        String cacheName = key.split("\\.")[0];
        if (!this.cacheNames.contains(cacheName)) {
            return true;
        }
        boolean result = this.cacheProvider.set(cacheName, key, value);
        if (logger.isDebugEnabled()) {
            logger.debug("set LEVEL1 cache:{}", (Object)key);
        }
        return result;
    }

    public <T> T get(String key) {
        if (this.cacheNames == null) {
            return null;
        }
        String cacheName = key.split("\\.")[0];
        if (!this.cacheNames.contains(cacheName)) {
            return null;
        }
        Object object = this.cacheProvider.get(cacheName, key);
        if (object != null) {
            logger.debug("get cache:{} from LEVEL1", (Object)key);
        }
        return object;
    }

    public void remove(String key) {
        if (this.cacheNames == null) {
            return;
        }
        String cacheName = key.split("\\.")[0];
        if (!this.cacheNames.contains(cacheName)) {
            return;
        }
        this.cacheProvider.remove(cacheName, key);
        logger.debug("remove LEVEL1 cache,cacheName:{},key:{}", (Object)cacheName, (Object)key);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cacheNames == null) {
            return;
        }
        if (this.cacheProvider == null) {
            this.cacheProvider = new GuavaLevel1CacheProvider();
        }
        this.cacheProvider.start();
        if (!this.distributedMode) {
            return;
        }
        Validate.notBlank((CharSequence)this.servers);
        String[] serverInfos = StringUtils.tokenizeToStringArray((String)this.servers, (String)",; \t\n")[0].split(":");
        final String host = serverInfos[0];
        final int port = Integer.parseInt(serverInfos[1]);
        this.listener = new LocalCacheSyncListener();
        this.redisCheckTimer = Executors.newScheduledThreadPool(1);
        this.redisCheckTimer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (Level1CacheSupport.this.subJedisClient == null) {
                    try {
                        Level1CacheSupport.this.subJedisClient = new Jedis(host, port);
                        if ("PONG".equals(Level1CacheSupport.this.subJedisClient.ping())) {
                            logger.info("subscribe localCache sync channel.....");
                            Level1CacheSupport.this.subJedisClient.subscribe((JedisPubSub)Level1CacheSupport.this.listener, new String[]{channelName});
                        }
                    }
                    catch (Exception e) {
                        try {
                            Level1CacheSupport.this.listener.unsubscribe();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Level1CacheSupport.this.subJedisClient.close();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            Level1CacheSupport.this.subJedisClient = null;
                        }
                    }
                }
            }
        }, 0L, 30L, TimeUnit.SECONDS);
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(1);
        poolConfig.setMinEvictableIdleTimeMillis(60000L);
        poolConfig.setMaxTotal(10);
        poolConfig.setMaxWaitMillis(30000L);
        this.pupJedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 3000, this.password);
    }

    public void destroy() throws Exception {
        if (this.cacheProvider != null) {
            this.cacheProvider.close();
        }
        if (this.redisCheckTimer != null) {
            this.redisCheckTimer.shutdown();
        }
        try {
            this.listener.unsubscribe();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.subJedisClient != null) {
            this.subJedisClient.close();
        }
        if (this.pupJedisPool != null) {
            this.pupJedisPool.close();
        }
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCacheProvider(Level1CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setDistributedMode(boolean distributedMode) {
        this.distributedMode = distributedMode;
    }

    public void setCacheNames(String cacheNames) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cacheNames)) {
            return;
        }
        String[] tmpcacheNames = StringUtils.tokenizeToStringArray((String)cacheNames, (String)",; \t\n");
        this.cacheNames = new ArrayList<String>(Arrays.asList(tmpcacheNames));
    }

    private class LocalCacheSyncListener
    extends JedisPubSub {
        private static final String CLEAR_ALL = "clearall";

        private LocalCacheSyncListener() {
        }

        public void onMessage(String channel, String message) {
            super.onMessage(channel, message);
            if (channel.equals(channelName)) {
                if (CLEAR_ALL.equals(message)) {
                    Level1CacheSupport.this.cacheProvider.clearAll();
                    logger.info("receive command {} and clear local cache finish!", (Object)CLEAR_ALL);
                } else {
                    try {
                        ClearCommand command = ClearCommand.deserialize(message);
                        if (command.isLocalCommand()) {
                            return;
                        }
                        Level1CacheSupport.this.cacheProvider.remove(command.getCacheName(), command.getKey());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

