/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.local;

import com.jeesuite.cache.local.Level1CacheProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhCacheLevel1CacheProvider
implements Level1CacheProvider {
    private CacheManager manager;
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private String ehcacheName;

    public void setEhcacheName(String ehcacheName) {
        this.ehcacheName = ehcacheName;
    }

    @Override
    public void start() {
        if (this.ehcacheName != null) {
            this.manager = CacheManager.getCacheManager((String)this.ehcacheName);
        }
        if (this.manager == null) {
            this.manager = new CacheManager();
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.shutdown();
    }

    @Override
    public boolean set(String cacheName, String key, Object value) {
        this.getCacheHolder(cacheName).put(new Element((Object)key, value));
        return true;
    }

    @Override
    public <T> T get(String cacheName, String key) {
        Element element = this.getCacheHolder(cacheName).get((Serializable)((Object)key));
        if (element == null) {
            return null;
        }
        return (T)element.getObjectValue();
    }

    @Override
    public void remove(String cacheName, String key) {
        this.getCacheHolder(cacheName).remove((Serializable)((Object)key));
    }

    @Override
    public void remove(String cacheName) {
        this.getCacheHolder(cacheName).removeAll();
    }

    @Override
    public void clearAll() {
        for (Cache cache : this.caches.values()) {
            cache.removeAll();
        }
    }

    private Cache getCacheHolder(String cacheName) {
        return this.getAndNotexistsCreateCache(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getAndNotexistsCreateCache(String cacheName) {
        Cache cache = this.caches.get(cacheName);
        if (cache != null) {
            return cache;
        }
        Map<String, Cache> map = this.caches;
        synchronized (map) {
            cache = this.caches.get(cacheName);
            if (cache != null) {
                return cache;
            }
            this.manager.addCache(cacheName);
            cache = this.manager.getCache(cacheName);
            this.caches.put(cacheName, cache);
        }
        return cache;
    }
}

