/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.command.RedisBase;
import com.jeesuite.cache.local.Level1CacheSupport;
import com.jeesuite.cache.redis.JedisProviderFactory;
import java.util.Date;
import redis.clients.util.SafeEncoder;

public class RedisObject
extends RedisBase {
    public RedisObject(String key) {
        super(key);
    }

    public RedisObject(String key, String groupName) {
        super(key, groupName);
    }

    public RedisObject resetKey(String key) {
        this.origKey = key;
        this.key = SafeEncoder.encode((String)key);
        return this;
    }

    public boolean set(Object value) {
        return this.set(value, RedisBase.getDefaultExpireSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(Object value, long seconds) {
        if (value == null) {
            return false;
        }
        try {
            boolean result = false;
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).set(this.key, this.valueSerialize(value)).equals("OK") : JedisProviderFactory.getBinaryJedisCommands(this.groupName).set(this.key, this.valueSerialize(value)).equals("OK");
            if (result) {
                result = this.setExpire(seconds);
                Level1CacheSupport.getInstance().publishSyncEvent(this.origKey);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(Object value, Date expireAt) {
        if (value == null) {
            return false;
        }
        try {
            boolean result = false;
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).set(this.key, this.valueSerialize(value)).equals("OK") : JedisProviderFactory.getBinaryJedisCommands(this.groupName).set(this.key, this.valueSerialize(value)).equals("OK");
            if (result) {
                result = this.setExpireAt(expireAt);
                Level1CacheSupport.getInstance().publishSyncEvent(this.origKey);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get() {
        try {
            Object value = Level1CacheSupport.getInstance().get(this.origKey);
            if (value != null) {
                Object t = value;
                return t;
            }
            byte[] bytes = null;
            bytes = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).get(this.key) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).get(this.key);
            value = this.valueDerialize(bytes);
            Level1CacheSupport.getInstance().set(this.origKey, value);
            Object t = value;
            return t;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    @Override
    public boolean remove() {
        boolean removed = super.remove();
        if (removed) {
            Level1CacheSupport.getInstance().publishSyncEvent(this.origKey);
        }
        return removed;
    }
}

