/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.command.RedisCollection;
import com.jeesuite.cache.redis.JedisProviderFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.util.SafeEncoder;

public class RedisHashMap
extends RedisCollection {
    public RedisHashMap(String key) {
        super(key);
    }

    public RedisHashMap(String key, long expireTime) {
        super(key, expireTime);
    }

    public RedisHashMap(String key, String groupName) {
        super(key, groupName);
    }

    public RedisHashMap(String key, String groupName, long expireTime) {
        super(key, groupName, expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean set(Map<String, T> datas) {
        if (datas == null || datas.isEmpty()) {
            return false;
        }
        HashMap<byte[], byte[]> newDatas = new HashMap<byte[], byte[]>();
        Set<String> keySet = datas.keySet();
        for (String key : keySet) {
            if (datas.get(key) == null) continue;
            newDatas.put(SafeEncoder.encode((String)key), this.valueSerialize(datas.get(key)));
        }
        boolean result = false;
        try {
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hmset(this.key, newDatas).equals("OK") : JedisProviderFactory.getBinaryJedisCommands(this.groupName).hmset(this.key, newDatas).equals("OK");
            if (result) {
                this.setExpireIfNot(this.expireTime);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> getAll() {
        try {
            Map datas = null;
            HashMap result = new HashMap();
            datas = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hgetAll(this.key) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).hgetAll(this.key);
            for (Map.Entry entry : datas.entrySet()) {
                result.put(SafeEncoder.encode((byte[])((byte[])entry.getKey())), this.valueDerialize((byte[])entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean containsKey(String field) {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hexists(this.key, SafeEncoder.encode((String)field));
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).hexists(this.key, SafeEncoder.encode((String)field));
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String field, Object value) {
        boolean result = false;
        if (value == null) {
            return false;
        }
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                result = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hset(this.key, SafeEncoder.encode((String)field), this.valueSerialize(value)) >= 0L;
            } else {
                boolean bl = result = JedisProviderFactory.getBinaryJedisCommands(this.groupName).hset(this.key, SafeEncoder.encode((String)field), this.valueSerialize(value)) >= 0L;
            }
            if (result) {
                this.setExpireIfNot(this.expireTime);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean remove(String field) {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hdel(this.key, (byte[][])new byte[][]{SafeEncoder.encode((String)field)}).equals("OK");
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).hdel(this.key, (byte[][])new byte[][]{SafeEncoder.encode((String)field)}).equals("OK");
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public long length() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                long l = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hlen(this.key);
                return l;
            }
            long l = JedisProviderFactory.getBinaryJedisCommands(this.groupName).hlen(this.key);
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public <T> T getOne(String field) {
        return this.get(field).get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> get(String ... fields) {
        try {
            List datas = null;
            HashMap result = new HashMap();
            for (String field : fields) {
                datas = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).hmget(this.key, (byte[][])new byte[][]{SafeEncoder.encode((String)field)}) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).hmget(this.key, (byte[][])new byte[][]{SafeEncoder.encode((String)field)});
                result.put(field, this.valueDerialize((byte[])datas.get(0)));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }
}

