/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.redis.JedisProviderFactory;
import com.jeesuite.common.serializer.SerializeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.util.SafeEncoder;

public class RedisBatchCommand {
    protected static final Logger logger = LoggerFactory.getLogger(RedisBatchCommand.class);
    protected static final String RESP_OK = "OK";

    public static boolean setStringsWithGroup(String groupName, Map<String, Object> keyValueMap) {
        if (keyValueMap == null || keyValueMap.isEmpty()) {
            return false;
        }
        String[] keysValues = new String[keyValueMap.size() * 2];
        int index = 0;
        for (String key : keyValueMap.keySet()) {
            if (keyValueMap.get(key) == null) continue;
            keysValues[index++] = key;
            keysValues[index++] = keyValueMap.get(key).toString();
        }
        if (JedisProviderFactory.isCluster(groupName)) {
            return JedisProviderFactory.getMultiKeyJedisClusterCommands(groupName).mset(keysValues).equals(RESP_OK);
        }
        return JedisProviderFactory.getMultiKeyCommands(groupName).mset(keysValues).equals(RESP_OK);
    }

    public static boolean setStrings(Map<String, Object> keyValueMap) {
        return RedisBatchCommand.setStringsWithGroup(null, keyValueMap);
    }

    public static boolean setObjectsWithGroup(String groupName, Map<String, Object> keyValueMap) {
        if (keyValueMap == null || keyValueMap.isEmpty()) {
            return false;
        }
        byte[][] keysValues = new byte[keyValueMap.size() * 2][];
        int index = 0;
        for (String key : keyValueMap.keySet()) {
            if (keyValueMap.get(key) == null) continue;
            keysValues[index++] = SafeEncoder.encode((String)key);
            keysValues[index++] = SerializeUtils.serialize((Object)keyValueMap.get(key));
        }
        if (JedisProviderFactory.isCluster(groupName)) {
            return JedisProviderFactory.getMultiKeyBinaryJedisClusterCommands(groupName).mset((byte[][])keysValues).equals(RESP_OK);
        }
        return JedisProviderFactory.getMultiKeyBinaryCommands(groupName).mset((byte[][])keysValues).equals(RESP_OK);
    }

    public static boolean setObjects(Map<String, Object> keyValueMap) {
        return RedisBatchCommand.setObjectsWithGroup(null, keyValueMap);
    }

    public static List<String> getStringsWithGroup(String groupName, String ... keys) {
        if (JedisProviderFactory.isCluster(groupName)) {
            return JedisProviderFactory.getMultiKeyJedisClusterCommands(groupName).mget(keys);
        }
        return JedisProviderFactory.getMultiKeyCommands(groupName).mget(keys);
    }

    public static List<String> getStrings(String ... keys) {
        return RedisBatchCommand.getStringsWithGroup(null, keys);
    }

    public static boolean removeStringsWithGroup(String groupName, String ... keys) {
        if (JedisProviderFactory.isCluster(groupName)) {
            return JedisProviderFactory.getMultiKeyJedisClusterCommands(groupName).del(keys) == 1L;
        }
        return JedisProviderFactory.getMultiKeyCommands(groupName).del(keys) == 1L;
    }

    public static boolean removeStrings(String ... keys) {
        return RedisBatchCommand.removeStringsWithGroup(null, keys);
    }

    public static boolean removeObjectsWithGroup(String groupName, String ... keys) {
        byte[][] byteKeys = SafeEncoder.encodeMany((String[])keys);
        if (JedisProviderFactory.isCluster(groupName)) {
            return JedisProviderFactory.getMultiKeyBinaryJedisClusterCommands(groupName).del(byteKeys) == 1L;
        }
        return JedisProviderFactory.getMultiKeyBinaryCommands(groupName).del(byteKeys) == 1L;
    }

    public static boolean removeObjects(String ... keys) {
        return RedisBatchCommand.removeObjectsWithGroup(null, keys);
    }

    public static <T> List<T> getObjectsWithGroup(String groupName, String ... keys) {
        byte[][] byteKeys = SafeEncoder.encodeMany((String[])keys);
        if (JedisProviderFactory.isCluster(groupName)) {
            List bytes = JedisProviderFactory.getMultiKeyBinaryJedisClusterCommands(groupName).mget(byteKeys);
            return RedisBatchCommand.listDerialize(bytes);
        }
        List bytes = JedisProviderFactory.getMultiKeyBinaryCommands(groupName).mget(byteKeys);
        return RedisBatchCommand.listDerialize(bytes);
    }

    public static <T> List<T> getObjects(String ... keys) {
        return RedisBatchCommand.getObjectsWithGroup(null, keys);
    }

    private static <T> T valueDerialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)SerializeUtils.deserialize((byte[])bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> List<T> listDerialize(List<byte[]> datas) {
        ArrayList<T> list = new ArrayList<T>();
        if (datas == null) {
            return list;
        }
        for (byte[] bs : datas) {
            list.add(RedisBatchCommand.valueDerialize(bs));
        }
        return list;
    }
}

