/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.redis.JedisProviderFactory;
import com.jeesuite.common.serializer.SerializeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.util.SafeEncoder;

public abstract class RedisBase {
    protected static final Logger logger = LoggerFactory.getLogger(RedisBase.class);
    protected static final String KEY_SUFFIX_SPLIT = "::";
    protected static final String RESP_OK = "OK";
    protected String groupName;
    protected byte[] key;
    protected String origKey;

    public byte[] getKey() {
        return this.key;
    }

    public RedisBase(String key) {
        this.origKey = key;
        if (key.contains(KEY_SUFFIX_SPLIT)) {
            this.groupName = key.split(KEY_SUFFIX_SPLIT)[0];
        }
        this.key = SafeEncoder.encode((String)key);
    }

    public RedisBase(String key, String groupName) {
        this.origKey = key;
        this.key = SafeEncoder.encode((String)key);
        this.groupName = groupName;
    }

    public boolean exists() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).exists(this.key);
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).exists(this.key);
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean remove() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).del(this.key) == 1L;
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).del(this.key) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setExpire(long seconds) {
        if (seconds <= 0L) {
            return true;
        }
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).pexpire(this.key, seconds * 1000L) == 1L;
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).pexpire(this.key, seconds * 1000L) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean setExpireAt(Date expireAt) {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).pexpireAt(this.key, expireAt.getTime()) == 1L;
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).pexpireAt(this.key, expireAt.getTime()) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean setExpireIfNot(long seconds) {
        Long ttl = this.getTtl();
        if (ttl == -1L) {
            return this.setExpire(seconds);
        }
        return ttl >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTtl() {
        try {
            long result = 0L;
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).ttl(this.key).longValue() : JedisProviderFactory.getBinaryJedisCommands(this.groupName).ttl(this.key).longValue();
            Long l = result;
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean removeExpire() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).persist(this.key) == 1L;
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).persist(this.key) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public String type() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                String string = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).type(this.key);
                return string;
            }
            String string = JedisProviderFactory.getBinaryJedisCommands(this.groupName).type(this.key);
            return string;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    protected byte[] valueSerialize(Object value) {
        try {
            return SerializeUtils.serialize((Object)value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected byte[][] valuesSerialize(Object ... objects) {
        try {
            byte[][] many = new byte[objects.length][];
            for (int i = 0; i < objects.length; ++i) {
                many[i] = SerializeUtils.serialize((Object)objects[i]);
            }
            return many;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T valueDerialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)SerializeUtils.deserialize((byte[])bytes);
        }
        catch (Exception e) {
            this.remove();
            logger.warn("get key[{}] from redis is not null,but Deserialize error,message:{}", (Object)this.origKey, (Object)e);
            return null;
        }
    }

    protected <T> List<T> listDerialize(List<byte[]> datas) {
        ArrayList<T> list = new ArrayList<T>();
        if (datas == null) {
            return list;
        }
        for (byte[] bs : datas) {
            list.add(this.valueDerialize(bs));
        }
        return list;
    }

    public static long getDefaultExpireSeconds() {
        return 604800L + RandomUtils.nextLong((long)1L, (long)86400L);
    }
}

