/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json.node;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.json.ActionReturn;
import org.beetl.json.JsonTool;
import org.beetl.json.JsonWriter;
import org.beetl.json.Location;
import org.beetl.json.LocationAction;
import org.beetl.json.OutputNode;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.action.IKeyAction;
import org.beetl.json.action.IValueAction;
import org.beetl.json.action.ValueIgnoreAction;
import org.beetl.json.node.NodeUtil;
import org.beetl.json.util.JsonUtil;
import org.beetl.json.util.MethodInvoker;
import org.beetl.json.util.Type;

public class PojoAttributeNode
extends OutputNode {
    protected Class parent;
    protected String attrName;
    protected Class attrType;
    protected OutputNodeKey atrrKey = null;
    protected MethodInvoker methodProxy = null;
    protected List<IKeyAction> keyActions = null;

    public PojoAttributeNode(Class parent, Method m) {
        this.parent = parent;
        this.attrType = m.getReturnType();
        this.attrName = JsonUtil.getAttribute(m);
        this.methodProxy = new MethodInvoker(parent, m, this.attrName);
    }

    @Override
    public void render(OutputNodeKey field, Object obj, JsonWriter w) throws IOException {
        String strKey = this.attrName;
        if (this.keyActions != null) {
            ActionReturn ar = null;
            for (IKeyAction keyAction : this.keyActions) {
                ar = keyAction.doit(strKey, this, w);
                if (ar.process == 0) {
                    strKey = (String)ar.value;
                    continue;
                }
                if (ar.process == 1) break;
                return;
            }
        }
        Object attrValue = null;
        try {
            attrValue = this.methodProxy.invoke(obj);
        }
        catch (RuntimeException ex) {
            w.getTool().attributeErrorHander.process(obj, strKey, w, ex.getCause());
            return;
        }
        if (this.valueActions == null) {
            if (attrValue == null) {
                if (this.atrrKey == null) {
                    w.writeKeyValue(strKey, null);
                } else {
                    w.writeKeyValue(this.atrrKey, null);
                }
                return;
            }
            switch (this.methodProxy.returnType) {
                case 0: {
                    if (this.atrrKey == null) {
                        w.writeKeyValue(strKey, attrValue);
                    } else {
                        w.writeKeyValue(this.atrrKey, attrValue);
                    }
                    return;
                }
                case 1: {
                    NodeUtil.writeIterator(this, this.atrrKey == null ? new OutputNodeKey(strKey) : this.atrrKey, (Iterable)attrValue, w);
                    return;
                }
                case 2: {
                    NodeUtil.writeMap(this, this.atrrKey == null ? new OutputNodeKey(strKey) : this.atrrKey, (Map)attrValue, w);
                    return;
                }
                case 4: {
                    w.getTool().serializeJW(w, this.atrrKey == null ? new OutputNodeKey(strKey) : this.atrrKey, attrValue, this.inHeritedPolicy);
                    return;
                }
            }
            NodeUtil.writeUnkonw(this, this.atrrKey == null ? new OutputNodeKey(strKey) : this.atrrKey, attrValue, w, this.valueActions);
            return;
        }
        NodeUtil.writeUnkonw(this, this.atrrKey == null ? new OutputNodeKey(strKey) : this.atrrKey, attrValue, w, this.valueActions);
    }

    @Override
    public void addActionIfMatchLocations(List<Location> list, JsonTool tool) {
        for (Location l : list) {
            if (!this.isMatch(l, tool)) continue;
            LocationAction action = l.getAction();
            if (action instanceof IKeyAction) {
                if (action instanceof ValueIgnoreAction) {
                    this.ignore = true;
                    continue;
                }
                this.addKeyAction((IKeyAction)action);
                continue;
            }
            if (!(action instanceof IValueAction)) continue;
            this.addValueAction((IValueAction)action);
        }
        if (this.valueActions != null) {
            this.methodProxy.returnType = Type.getType(this.methodProxy.m.getReturnType());
        }
        if (this.keyActions == null) {
            this.atrrKey = new OutputNodeKey(this.attrName.toCharArray());
        }
    }

    protected boolean isMatch(Location location, JsonTool tool) {
        return location.match(this, this.attrType, this.attrName, tool);
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public Class getAttrType() {
        return this.attrType;
    }

    public void setAttrType(Class attrType) {
        this.attrType = attrType;
    }

    public void addKeyAction(IKeyAction keyAction) {
        if (this.keyActions == null) {
            this.keyActions = new LinkedList<IKeyAction>();
        }
        this.keyActions.add(keyAction);
    }
}

