/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json.action;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beetl.json.ActionReturn;
import org.beetl.json.DirectOutputValue;
import org.beetl.json.JsonWriter;
import org.beetl.json.OutputNode;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.action.IValueAction;

public class IfAction
implements IValueAction {
    String condtion;
    String output;

    public IfAction(String condtion, String output) {
        this.condtion = condtion;
        this.output = output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActionReturn doit(OutputNodeKey field, Object o, OutputNode thisNode, JsonWriter w) {
        DirectOutputValue value = new DirectOutputValue(this.output);
        ActionReturn ret = new ActionReturn(value, 1);
        if (this.condtion.equals("empty")) {
            if (o == null) {
                return ret;
            }
            if (o instanceof String) {
                if (((String)o).length() != 0) return new ActionReturn(o, 0);
                return ret;
            }
            if (o instanceof Collection) {
                if (((Collection)o).size() != 0) return new ActionReturn(o, 0);
                return ret;
            }
            if (o instanceof Map) {
                if (((Map)o).size() != 0) return new ActionReturn(o, 0);
                return ret;
            }
            if (!o.getClass().isArray()) return ret;
            Object[] array = (Object[])o;
            if (array.length != 0) return new ActionReturn(o, 0);
            return ret;
        }
        if (this.condtion.equals("null")) {
            if (o != null) return new ActionReturn(o, 0);
            return ret;
        }
        if (!(o instanceof Number) || !this.isNumeric(this.condtion)) return new ActionReturn(o, 0);
        Number nu = (Number)o;
        double cond = Double.parseDouble(this.condtion);
        if (nu.doubleValue() != cond) return new ActionReturn(o, 0);
        return ret;
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

