/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json;

import java.util.ArrayList;
import java.util.List;
import org.beetl.json.JsonException;
import org.beetl.json.JsonTool;
import org.beetl.json.Location;
import org.beetl.json.LocationAction;
import org.beetl.json.annotation.Json;
import org.beetl.json.annotation.JsonPolicy;
import org.beetl.json.loc.AttributeLocation;
import org.beetl.json.loc.ClassTypeLocation;
import org.beetl.json.loc.IndexLocation;
import org.beetl.json.loc.MatchAllFieldLocation;
import org.beetl.json.loc.ThisLocation;
import org.beetl.json.loc.TypeLocation;

public class PolicyParser {
    public static List<Location> parseAnnotation(Class cls, JsonTool tool) {
        Json json = cls.getAnnotation(Json.class);
        if (json != null) {
            JsonPolicy[] policys = json.policys();
            ArrayList<Location> list = new ArrayList<Location>(policys.length);
            for (JsonPolicy po : policys) {
                list.add(PolicyParser.parse(cls, po.location(), po.action(), tool));
            }
            Class parent = cls.getSuperclass();
            if (!tool.isStopParse(parent.getName())) {
                List<Location> supers = PolicyParser.parseAnnotation(parent, tool);
                list.addAll(0, supers);
                return list;
            }
            return list;
        }
        return new ArrayList<Location>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Location parse(Class c, String loc, String act, JsonTool tool) {
        boolean parseAction = true;
        LocationAction action = null;
        Location location = null;
        if (loc.startsWith("~")) {
            String cmd = loc.substring(1);
            if (cmd.equals("n")) {
                location = new TypeLocation(cmd);
            } else if (cmd.equals("d")) {
                location = new TypeLocation(cmd);
            } else if (cmd.equals("*")) {
                if (c == null) {
                    c = Object.class;
                }
                location = new ThisLocation(c);
            } else if (cmd.equals("c")) {
                location = new TypeLocation(cmd);
            } else {
                if (!cmd.startsWith("L/")) throw new UnsupportedOperationException();
                String clsName = cmd.substring(2, cmd.length() - 1);
                location = clsName.endsWith("*") ? new ClassTypeLocation(PolicyParser.getClassByName(clsName.substring(0, clsName.length() - 1), tool), false, loc + ":" + act) : new ClassTypeLocation(PolicyParser.getClassByName(clsName, tool), true, loc + ":" + act);
            }
        } else if (loc.startsWith("[")) {
            int index = loc.indexOf("]");
            String strRef = loc.substring(1, index);
            Object ref = null;
            try {
                ref = Integer.parseInt(strRef);
            }
            catch (Exception ex) {
                ref = strRef;
            }
            if (index == loc.length() - 1) {
                location = new IndexLocation(ref);
            } else if (loc.charAt(index + 1) == '.') {
                String newLocation = loc.substring(index + 2);
                location = new IndexLocation(ref);
                Location nextLoc = PolicyParser.parse(c, newLocation, act, tool);
                parseAction = false;
                location.setNextLoc(nextLoc);
            } else {
                if (loc.charAt(index + 1) != '[') throw new JsonException(0, "\u89e3\u6790\u9519:" + loc);
                String nextLocation = loc.substring(index + 1);
                location = new IndexLocation(ref);
                Location nextLoc = PolicyParser.parse(c, nextLocation, act, tool);
                parseAction = false;
                location.setNextLoc(nextLoc);
            }
        } else if (loc.startsWith("*./")) {
            String reg = loc.substring(2, loc.length());
            location = new MatchAllFieldLocation(reg);
        } else if (loc.equals("*")) {
            location = new MatchAllFieldLocation();
        } else if (loc.startsWith("/")) {
            Object[] result = PolicyParser.parseRegAttribute(c, loc, act, tool);
            location = (Location)result[0];
            parseAction = (Boolean)result[1];
        } else {
            Object[] result = PolicyParser.parseAttribute(c, loc, act, tool);
            location = (Location)result[0];
            parseAction = (Boolean)result[1];
        }
        location.setTool(tool);
        if (!parseAction) return location;
        action = location.parseAction(act);
        location.setAction(action);
        return location;
    }

    protected static Object[] parseAttribute(Class c, String loc, String act, JsonTool tool) {
        AttributeLocation location = null;
        String attrName = loc;
        char[] chs = attrName.toCharArray();
        boolean findSub = false;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] != '.' && chs[i] != '[') continue;
            findSub = true;
            String thisAttr = attrName.substring(0, i);
            String nextLocStr = null;
            nextLocStr = chs[i] == '.' ? attrName.substring(i + 1) : attrName.substring(i);
            location = new AttributeLocation(thisAttr);
            location.setNextLoc(PolicyParser.parse(c, nextLocStr, act, tool));
            break;
        }
        if (!findSub) {
            location = new AttributeLocation(attrName);
            return new Object[]{location, true};
        }
        return new Object[]{location, false};
    }

    protected static Object[] parseRegAttribute(Class c, String loc, String act, JsonTool tool) {
        AttributeLocation location = null;
        String attrName = loc;
        int index = attrName.indexOf(47, 1);
        if (index == 0) {
            throw new JsonException(0, "must /xxx/");
        }
        attrName = attrName.substring(0, index + 1);
        if (loc.length() > index + 1) {
            String nextLocStr = null;
            char ch = loc.charAt(index + 1);
            nextLocStr = ch == '.' ? attrName.substring(index + 1) : attrName.substring(index);
            location = new AttributeLocation(attrName);
            location.setNextLoc(PolicyParser.parse(c, nextLocStr, act, tool));
            return new Object[]{location, false};
        }
        location = new AttributeLocation(attrName);
        return new Object[]{location, true};
    }

    public static List<Location> parseStringPolicy(Class c, String policy, JsonTool jsonTool) {
        ArrayList<Location> list = new ArrayList<Location>();
        char[] chars = policy.toCharArray();
        int start = 0;
        boolean findKey = true;
        String key = null;
        String value = null;
        boolean paraStat = false;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (findKey) {
                if (ch != ':') continue;
                findKey = false;
                key = new String(chars, start, i - start);
                start = i + 1;
                continue;
            }
            if (!paraStat) {
                if (ch == ',') {
                    findKey = true;
                    value = new String(chars, start, i - start);
                    start = i + 1;
                    Location location = PolicyParser.parse(c, key, value, jsonTool);
                    list.add(location);
                    continue;
                }
                if (ch != '/') continue;
                paraStat = true;
                continue;
            }
            if (ch != '/') continue;
            paraStat = false;
        }
        if (!findKey && start != chars.length) {
            value = new String(chars, start, chars.length - start);
            Location location = PolicyParser.parse(c, key, value, jsonTool);
            list.add(location);
        }
        return list;
    }

    protected static Class getClassByName(String clsName, JsonTool tool) {
        String name = tool.getNameByAlias(clsName);
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new JsonException(0, "\u627e\u4e0d\u5230\u7c7b" + name);
        }
    }
}

