/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.json.DirectOutputValue;
import org.beetl.json.JsonTool;
import org.beetl.json.Location;
import org.beetl.json.OutputNode;
import org.beetl.json.Policy;
import org.beetl.json.PolicyParser;
import org.beetl.json.node.ArrayNode;
import org.beetl.json.node.IterableClassNode;
import org.beetl.json.node.JavaObjectNode;
import org.beetl.json.node.MapClassNode;
import org.beetl.json.node.PojoNode;

public class PolicyCache {
    JsonTool jsonTool = null;
    Map<Class, Map<String, Map<List<Location>, Policy>>> cache = new HashMap<Class, Map<String, Map<List<Location>, Policy>>>();
    Map<Class, List<Location>> clsAnnotation = new HashMap<Class, List<Location>>();
    Map<Class, Policy> fastCache = new HashMap<Class, Policy>();

    public PolicyCache(JsonTool jsonTool) {
        this.jsonTool = jsonTool;
    }

    public synchronized Policy getPolicy(Class cls, String policyStr, List<Location> inheritList) {
        Policy policy;
        Map<List<Location>, Policy> cache3;
        Policy policy2;
        if (cls == DirectOutputValue.class) {
            return Policy.directPolicy;
        }
        if (!(policyStr != null && policyStr.length() != 0 || inheritList != null && inheritList.size() != 0 || (policy2 = this.fastCache.get(cls)) == null)) {
            return policy2;
        }
        String clsName = cls.getName();
        Map<String, Map<List<Location>, Policy>> cache2 = this.cache.get(cls);
        if (cache2 == null) {
            cache2 = new HashMap<String, Map<List<Location>, Policy>>();
            this.cache.put(cls, cache2);
        }
        if (policyStr == null) {
            policyStr = "";
        }
        if ((cache3 = cache2.get(policyStr)) == null) {
            cache3 = new HashMap<List<Location>, Policy>();
            cache2.put(policyStr, cache3);
        }
        if ((policy = cache3.get(inheritList)) == null) {
            policy = this.createPolicy(cls, policyStr, inheritList);
            if (!(policyStr != null && policyStr.length() != 0 || inheritList != null && inheritList.size() != 0)) {
                this.fastCache.put(cls, policy);
            }
            cache3.put(inheritList, policy);
        }
        return policy;
    }

    public Policy createPolicy(Class cls, String policyStr, List<Location> inheritList) {
        List<Location> annotation = this.clsAnnotation.get(cls);
        if (annotation == null) {
            annotation = PolicyParser.parseAnnotation(cls, this.jsonTool);
            this.clsAnnotation.put(cls, annotation);
        }
        List<Location> policy = PolicyParser.parseStringPolicy(cls, policyStr, this.jsonTool);
        LinkedList<Location> all = new LinkedList<Location>(this.jsonTool.defaultLocs);
        all.addAll(annotation);
        all.addAll(policy);
        if (inheritList != null) {
            all.addAll(inheritList);
        }
        OutputNode node = null;
        Policy jsonPolicy = null;
        node = Iterable.class.isAssignableFrom(cls) ? new IterableClassNode() : (Iterator.class.isAssignableFrom(cls) ? new IterableClassNode() : (Map.class.isAssignableFrom(cls) ? new MapClassNode() : (cls.isArray() ? new ArrayNode() : (cls.getPackage().getName().startsWith("java") ? new JavaObjectNode(cls) : new PojoNode(cls)))));
        ((OutputNode)node).addActionIfMatchLocations(all, this.jsonTool);
        jsonPolicy = new Policy(node);
        return jsonPolicy;
    }
}

