/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.json;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.beetl.json.DirectOutputValue;
import org.beetl.json.JsonTool;
import org.beetl.json.OutputNodeKey;
import org.beetl.json.util.ContextLocal;
import org.beetl.json.util.IntIOWriter;

public class JsonWriter {
    Writer w = null;
    char quotes = '\u0000';
    static char[] NULL = "null".toCharArray();
    static char[] trueChar = "true".toCharArray();
    static char[] falseChar = "false".toCharArray();
    static char[] emptySquare = "[]".toCharArray();
    static char[] emptyBrace = "{}".toCharArray();
    boolean pretty = false;
    int indent = 0;
    ContextLocal localBuffer = ContextLocal.get();
    boolean[] scope = this.localBuffer.getScope();
    int scopeIndex = 0;
    Map<Object, Object> objectMapPath = new LinkedHashMap<Object, Object>();
    JsonTool tool = null;

    public JsonWriter(Writer w, JsonTool tool) {
        this.w = w;
        this.tool = tool;
        this.quotes = tool.singleQuotes ? (char)39 : (char)34;
        this.pretty = tool.pretty;
    }

    protected void writeComma() throws IOException {
        if (this.scope[this.scopeIndex]) {
            this.scope[this.scopeIndex] = false;
            return;
        }
        this.w.write(44);
    }

    public void writeKeyValue(OutputNodeKey key, Object value) throws IOException {
        this.writeKey(key);
        this.writeValue(value);
    }

    public void writeKeyValue(String key, Object value) throws IOException {
        this.writeComma();
        this.writeKey(key);
        this.write(':');
        this.writeValue(value);
    }

    public void writeScopeNull() throws IOException {
        this.writeComma();
        this.writeNull();
    }

    public boolean isFirstInScope() {
        return this.scope[this.scopeIndex];
    }

    public void writeScopeChar(char c) throws IOException {
        switch (c) {
            case '[': 
            case '{': {
                if (this.pretty) {
                    this.w.write(10);
                    this.writeIndent();
                    ++this.indent;
                }
                ++this.scopeIndex;
                this.scope[this.scopeIndex] = true;
                break;
            }
            case ']': 
            case '}': {
                if (this.pretty) {
                    this.w.write(10);
                    --this.indent;
                    this.writeIndent();
                }
                --this.scopeIndex;
            }
        }
        this.w.write(c);
    }

    public void write(char c) throws IOException {
        this.w.write(c);
    }

    protected void writeKey(String key) throws IOException {
        if (this.pretty) {
            this.w.write(10);
            this.writeIndent();
        }
        this.w.write(this.quotes);
        this.w.write(key);
        this.w.write(this.quotes);
    }

    protected void writeKey(char[] key) throws IOException {
        if (this.pretty) {
            this.w.write(10);
            this.writeIndent();
        }
        this.w.write(this.quotes);
        this.w.write(key);
        this.w.write(this.quotes);
    }

    private void writeBoolean(Boolean b) throws IOException {
        if (b.booleanValue()) {
            this.w.write(trueChar);
        } else {
            this.w.write(falseChar);
        }
    }

    public void writeNull() throws IOException {
        this.w.write(NULL);
    }

    public void writeEmptySqure() throws IOException {
        this.w.write(emptySquare);
    }

    public void writeEmptyBrace() throws IOException {
        this.w.write(emptyBrace);
    }

    public void writeValue(Object o) throws IOException {
        if (o == null) {
            this.w.write(NULL);
        } else if (o instanceof String) {
            this.w.write(this.quotes);
            this.w.write(o.toString());
            this.w.write(this.quotes);
        } else if (o instanceof Boolean) {
            this.writeBoolean((Boolean)o);
        } else if (o instanceof Number) {
            if (o instanceof Integer) {
                IntIOWriter.writeInteger(this, (Integer)o);
            } else {
                this.w.write(o.toString());
            }
        } else if (o instanceof DirectOutputValue) {
            this.w.write(o.toString());
        } else {
            this.w.write(this.quotes);
            this.w.write(o.toString());
            this.w.write(this.quotes);
        }
    }

    public void writeNumberChars(char[] chars, int len) throws IOException {
        this.w.write(chars, 0, len);
    }

    protected void writeIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.w.write(9);
        }
    }

    public ContextLocal getLocalBuffer() {
        return this.localBuffer;
    }

    public void addObjectPath(Object field, Object o) {
        this.objectMapPath.put(o, field);
    }

    public void removeObjectPath(Object o) {
        this.objectMapPath.remove(o);
    }

    public boolean containObjectInPath(Object o) {
        return this.objectMapPath.containsKey(o);
    }

    public String getObjectPath(Object o) {
        StringBuilder sb = null;
        for (Map.Entry<Object, Object> entry : this.objectMapPath.entrySet()) {
            Object key = entry.getKey();
            OutputNodeKey value = (OutputNodeKey)entry.getValue();
            if (value == null) {
                sb = new StringBuilder("$");
            } else if (value.isIndex()) {
                sb.append('[').append(value).append(']');
            } else {
                sb.append('.').append(value.toString());
            }
            if (!o.equals(key)) continue;
            return sb.toString();
        }
        throw new RuntimeException("\u4e0d\u53ef\u80fd\u53d1\u751f");
    }

    public void writeKey(OutputNodeKey nodeKey) throws IOException {
        if (nodeKey == null) {
            return;
        }
        Object key = nodeKey.getKey();
        if (key == null) {
            return;
        }
        this.writeComma();
        if (!nodeKey.isIndex()) {
            if (nodeKey.isFix()) {
                this.writeKey((char[])key);
            } else {
                this.writeKey((String)key);
            }
            this.write(':');
        }
    }

    public JsonTool getTool() {
        return this.tool;
    }

    public void setTool(JsonTool tool) {
        this.tool = tool;
    }

    public char getQuotes() {
        return this.quotes;
    }
}

