/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring4;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.beetl.sql.ext.spring4.BeetlSqlFactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

public class BeetlSqlClassPathScanner
extends ClassPathBeanDefinitionScanner {
    String sqlManagerFactoryBeanName;
    String suffix;

    public BeetlSqlClassPathScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        this.addIncludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                return className.endsWith(BeetlSqlClassPathScanner.this.suffix);
            }
        });
        this.addExcludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                return className.endsWith("package-info");
            }
        });
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("BeetlSql\u6ca1\u6709\u5728 '" + Arrays.toString(basePackages) + "' \u5305\u4e2d\u627e\u5230\u4efb\u4f55Mapper\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e"));
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            this.logger.debug((Object)holder.toString());
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            definition.getPropertyValues().add("mapperInterface", (Object)definition.getBeanClassName());
            definition.getPropertyValues().add("sqlManager", (Object)new RuntimeBeanReference(this.sqlManagerFactoryBeanName));
            definition.setBeanClass(BeetlSqlFactoryBean.class);
            definition.setAutowireMode(2);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("\u5df2\u5f00\u542fBeetSql\u81ea\u52a8\u6309\u7167\u7c7b\u578b\u6ce8\u5165 '" + holder.getBeanName() + "'."));
        }
    }

    public void setSqlManagerFactoryBeanName(String sqlManagerFactoryBeanName) {
        this.sqlManagerFactoryBeanName = sqlManagerFactoryBeanName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

