/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import org.beetl.core.GroupTemplate;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringView;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class BeetlSpringViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean,
BeanNameAware {
    private String beanName = null;
    private BeetlGroupUtilConfiguration config;
    private GroupTemplate groupTemplate = null;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setGroupTemplate(GroupTemplate groupTemplate) {
        this.groupTemplate = groupTemplate;
    }

    public BeetlSpringViewResolver() {
        this.setViewClass(BeetlSpringView.class);
    }

    public void afterPropertiesSet() throws NoSuchBeanDefinitionException, NoUniqueBeanDefinitionException, SecurityException, NoSuchFieldException {
        if (this.config == null) {
            this.config = (BeetlGroupUtilConfiguration)this.getApplicationContext().getBean(BeetlGroupUtilConfiguration.class);
            this.groupTemplate = this.config.getGroupTemplate();
        }
        if (this.getContentType() == null) {
            String charset = this.groupTemplate.getConf().getCharset();
            this.setContentType("text/html;charset=" + charset);
        }
    }

    protected Class<BeetlSpringView> requiredViewClass() {
        return BeetlSpringView.class;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        BeetlSpringView beetlView = (BeetlSpringView)super.buildView(viewName);
        beetlView.setGroupTemplate(this.groupTemplate);
        String suffix = this.getSuffix();
        if (suffix != null && suffix.length() != 0 && viewName.contains("#")) {
            String[] split = viewName.split("#");
            if (split.length > 2) {
                throw new Exception("\u89c6\u56fe\u540d\u79f0\u6709\u8bef\uff1a" + viewName);
            }
            beetlView.setUrl(this.getPrefix() + split[0] + this.getSuffix() + "#" + split[1]);
        }
        return beetlView;
    }

    public static String redirect(String url) {
        return "redirect:" + url;
    }

    public static String forward(String url) {
        return "forward:" + url;
    }

    public BeetlGroupUtilConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(BeetlGroupUtilConfiguration config) {
        this.config = config;
        this.groupTemplate = config.getGroupTemplate();
    }
}

