/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.compress.ByteArrayCompressor;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class StreamCompressor
extends ByteArrayCompressor {
    public StreamCompressor(Serializer serializer) {
        super(serializer, 2048);
    }

    public StreamCompressor(Serializer serializer, int bufferSize) {
        super(serializer, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(byte[] inputBytes, int inputLength, ByteBuffer outputBuffer) {
        ByteArrayOutputStream outputBufferStream = new ByteArrayOutputStream(outputBuffer.array());
        try {
            FilterOutputStream output = this.getCompressionStream(outputBufferStream);
            try {
                output.write(inputBytes, 0, inputLength);
            }
            finally {
                output.close();
            }
            outputBuffer.position(outputBufferStream.size());
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public abstract FilterOutputStream getCompressionStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompress(byte[] inputBytes, int inputLength, ByteBuffer outputBuffer) {
        ByteArrayInputStream inputBufferStream = new ByteArrayInputStream(inputBytes);
        inputBufferStream.setCount(inputLength);
        try {
            FilterInputStream input = this.getDecompressionStream(inputBufferStream);
            try {
                outputBuffer.position(input.read(outputBuffer.array(), 0, outputBuffer.capacity()));
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public abstract FilterInputStream getDecompressionStream(InputStream var1) throws IOException;

    private static class ByteArrayInputStream
    extends java.io.ByteArrayInputStream {
        public ByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void setCount(int count) {
            this.count = count;
        }
    }

    private static class ByteArrayOutputStream
    extends java.io.ByteArrayOutputStream {
        public ByteArrayOutputStream(byte[] buf) {
            super(0);
            this.buf = buf;
        }
    }
}

