/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.grapher.NameFactory;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.ElementSource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ShortNameFactory
implements NameFactory {
    @Override
    public String getMemberName(Member member) {
        if (member instanceof Constructor) {
            return "<init>";
        }
        if (member instanceof Method) {
            String string = String.valueOf(String.valueOf(member.getName()));
            return new StringBuilder(6 + string.length()).append("#").append(string).append("(...)").toString();
        }
        return member.getName();
    }

    @Override
    public String getAnnotationName(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        Class<? extends Annotation> annotationType = key.getAnnotationType();
        if (annotation != null) {
            annotationType = annotation.annotationType();
            String annotationString = annotation.toString();
            String canonicalName = annotationType.getName();
            String simpleName = annotationType.getSimpleName();
            return annotationString.replace(canonicalName, simpleName).replace("()", "");
        }
        if (annotationType != null) {
            String string = String.valueOf(annotationType.getSimpleName());
            return string.length() != 0 ? "@".concat(string) : new String("@");
        }
        return "";
    }

    @Override
    public String getClassName(Key<?> key) {
        TypeLiteral typeLiteral = key.getTypeLiteral();
        return this.stripPackages(typeLiteral.toString());
    }

    @Override
    public String getInstanceName(Object instance) {
        if (instance instanceof ProviderMethod) {
            return this.getMethodString(((ProviderMethod)instance).getMethod());
        }
        if (instance instanceof CharSequence) {
            String string = String.valueOf(String.valueOf(instance));
            return new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }
        try {
            if (instance.getClass().getMethod("toString", new Class[0]).getDeclaringClass().equals(Object.class)) {
                return this.stripPackages(instance.getClass().getName());
            }
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        return instance.toString();
    }

    @Override
    public String getSourceName(Object source) {
        if (source instanceof ElementSource) {
            source = ((ElementSource)source).getDeclaringSource();
        }
        if (source instanceof Method) {
            source = StackTraceElements.forMember((Member)((Method)source));
        }
        if (source instanceof StackTraceElement) {
            return this.getFileString((StackTraceElement)source);
        }
        return this.stripPackages(source.toString());
    }

    protected String getFileString(StackTraceElement stackTraceElement) {
        String string = String.valueOf(String.valueOf(stackTraceElement.getFileName()));
        int n = stackTraceElement.getLineNumber();
        return new StringBuilder(12 + string.length()).append(string).append(":").append(n).toString();
    }

    protected String getMethodString(Method method) {
        ArrayList paramStrings = Lists.newArrayList();
        for (Class<?> paramType : method.getParameterTypes()) {
            paramStrings.add(paramType.getSimpleName());
        }
        String paramString = Joiner.on((String)", ").join((Iterable)paramStrings);
        String string = String.valueOf(String.valueOf(method.getName()));
        String string2 = String.valueOf(String.valueOf(paramString));
        return new StringBuilder(3 + string.length() + string2.length()).append("#").append(string).append("(").append(string2).append(")").toString();
    }

    private String stripPackages(String str) {
        return str.replaceAll("(^|[< .\\(])([a-z0-9]+\\.)*", "$1");
    }
}

