/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.grapher.Renderer;
import com.google.inject.internal.util.;
import com.google.inject.spi.BindingTargetVisitor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorGrapher {
    private static final Key<Logger> loggerKey = Key.get(Logger.class);
    private final BindingTargetVisitor<Object, Collection<Key<?>>> keyVisitor;
    private final BindingTargetVisitor<Object, Void> graphingVisitor;
    private final Renderer renderer;
    private Injector injector;
    private Set<Key<?>> root;

    @Inject
    public InjectorGrapher(BindingTargetVisitor<Object, Collection<Key<?>>> keyVisitor, BindingTargetVisitor<Object, Void> graphingVisitor, Renderer renderer) {
        this.keyVisitor = keyVisitor;
        this.graphingVisitor = graphingVisitor;
        this.renderer = renderer;
    }

    public InjectorGrapher of(Injector injector) {
        this.injector = injector;
        return this;
    }

    public InjectorGrapher rootedAt(Class<?> ... classes) {
        this.root = .Sets.newHashSet();
        for (Class<?> clazz : classes) {
            this.root.add(Key.get(clazz));
        }
        return this;
    }

    public InjectorGrapher rootedAt(Key<?> ... keys) {
        this.root = .Sets.newHashSet();
        for (Key<?> key : keys) {
            this.root.add(key);
        }
        return this;
    }

    public void graph() throws IOException {
        this.processBindings();
        this.renderer.render();
    }

    private boolean skipKey(Key<?> key) {
        return key.getTypeLiteral().getRawType().getPackage() == Guice.class.getPackage() || loggerKey.equals(key);
    }

    private void processBindings() {
        LinkedHashSet keys = .Sets.newLinkedHashSet();
        HashSet visitedKeys = .Sets.newHashSet();
        if (this.root == null) {
            for (Key key : this.injector.getBindings().keySet()) {
                if (this.skipKey(key)) continue;
                keys.add(key);
            }
        } else {
            keys.addAll(this.root);
        }
        while (!keys.isEmpty()) {
            Key key;
            Iterator iterator = keys.iterator();
            key = (Key)iterator.next();
            iterator.remove();
            if (visitedKeys.contains(key)) continue;
            Binding binding = this.injector.getBinding(key);
            visitedKeys.add(key);
            binding.acceptTargetVisitor(this.graphingVisitor);
            Collection newKeys = (Collection)binding.acceptTargetVisitor(this.keyVisitor);
            if (newKeys == null) continue;
            keys.addAll(newKeys);
        }
    }
}

