/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClusterException
extends RuntimeException {
    public final Collection<? extends Throwable> exceptions;

    private ClusterException(Collection<? extends Throwable> exceptions) {
        super(String.format("%d exceptions were thrown. The first exception is listed as a cause.", exceptions.size()), exceptions.iterator().next());
        ArrayList<? extends Throwable> temp = new ArrayList<Throwable>();
        temp.addAll(exceptions);
        this.exceptions = Collections.unmodifiableCollection(temp);
    }

    public static RuntimeException create(Throwable ... exceptions) {
        ArrayList<Throwable> temp = new ArrayList<Throwable>();
        for (Throwable exception : exceptions) {
            temp.add(exception);
        }
        return ClusterException.create(temp);
    }

    public static RuntimeException create(Collection<? extends Throwable> exceptions) {
        if (exceptions.size() == 0) {
            throw new IllegalArgumentException("Can't create an ExceptionCollection with no exceptions");
        }
        if (exceptions.size() == 1) {
            Throwable temp = exceptions.iterator().next();
            if (temp instanceof RuntimeException) {
                return (RuntimeException)temp;
            }
            return new RuntimeException(temp);
        }
        return new ClusterException(exceptions);
    }
}

