/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNavigationTester<E>
extends AbstractSetTester<E> {
    private NavigableSet<E> navigableSet;
    private List<E> values;
    private E a;
    private E b;
    private E c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.navigableSet = (NavigableSet)this.getSet();
        this.values = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(this.values, this.navigableSet.comparator());
        if (this.values.size() >= 1) {
            this.a = this.values.get(0);
            if (this.values.size() >= 3) {
                this.b = this.values.get(1);
                this.c = this.values.get(2);
            }
        }
    }

    protected void resetWithHole() {
        super.resetContainer((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.a, this.c));
        this.navigableSet = (NavigableSet)this.getSet();
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetFirst() {
        try {
            this.navigableSet.first();
            SetNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetPollFirst() {
        SetNavigationTester.assertNull(this.navigableSet.pollFirst());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetNearby() {
        SetNavigationTester.assertNull(this.navigableSet.lower(this.samples.e0));
        SetNavigationTester.assertNull(this.navigableSet.floor(this.samples.e0));
        SetNavigationTester.assertNull(this.navigableSet.ceiling(this.samples.e0));
        SetNavigationTester.assertNull(this.navigableSet.higher(this.samples.e0));
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetLast() {
        try {
            this.navigableSet.last();
            SetNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetPollLast() {
        SetNavigationTester.assertNull(this.navigableSet.pollLast());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetFirst() {
        SetNavigationTester.assertEquals(this.a, this.navigableSet.first());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetPollFirst() {
        SetNavigationTester.assertEquals(this.a, this.navigableSet.pollFirst());
        SetNavigationTester.assertTrue((boolean)this.navigableSet.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetNearby() {
        SetNavigationTester.assertNull(this.navigableSet.lower(this.samples.e0));
        SetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.samples.e0));
        SetNavigationTester.assertEquals(this.a, this.navigableSet.ceiling(this.samples.e0));
        SetNavigationTester.assertNull(this.navigableSet.higher(this.samples.e0));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetLast() {
        SetNavigationTester.assertEquals(this.a, this.navigableSet.last());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetPollLast() {
        SetNavigationTester.assertEquals(this.a, this.navigableSet.pollLast());
        SetNavigationTester.assertTrue((boolean)this.navigableSet.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        SetNavigationTester.assertEquals(this.a, this.navigableSet.first());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollFirst() {
        SetNavigationTester.assertEquals(this.a, this.navigableSet.pollFirst());
        SetNavigationTester.assertEquals(this.values.subList(1, this.values.size()), Helpers.copyToList(this.navigableSet));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testPollFirstUnsupported() {
        try {
            this.navigableSet.pollFirst();
            SetNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLower() {
        this.resetWithHole();
        SetNavigationTester.assertEquals(null, this.navigableSet.lower(this.a));
        SetNavigationTester.assertEquals(this.a, this.navigableSet.lower(this.b));
        SetNavigationTester.assertEquals(this.a, this.navigableSet.lower(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFloor() {
        this.resetWithHole();
        SetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.a));
        SetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.b));
        SetNavigationTester.assertEquals(this.c, this.navigableSet.floor(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCeiling() {
        this.resetWithHole();
        SetNavigationTester.assertEquals(this.a, this.navigableSet.ceiling(this.a));
        SetNavigationTester.assertEquals(this.c, this.navigableSet.ceiling(this.b));
        SetNavigationTester.assertEquals(this.c, this.navigableSet.ceiling(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testHigher() {
        this.resetWithHole();
        SetNavigationTester.assertEquals(this.c, this.navigableSet.higher(this.a));
        SetNavigationTester.assertEquals(this.c, this.navigableSet.higher(this.b));
        SetNavigationTester.assertEquals(null, this.navigableSet.higher(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        SetNavigationTester.assertEquals(this.c, this.navigableSet.last());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLast() {
        SetNavigationTester.assertEquals(this.c, this.navigableSet.pollLast());
        SetNavigationTester.assertEquals(this.values.subList(0, this.values.size() - 1), Helpers.copyToList(this.navigableSet));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testPollLastUnsupported() {
        try {
            this.navigableSet.pollLast();
            SetNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testDescendingNavigation() {
        ArrayList<E> descending = new ArrayList<E>();
        Iterator<E> i = this.navigableSet.descendingIterator();
        while (i.hasNext()) {
            descending.add(i.next());
        }
        Collections.reverse(descending);
        SetNavigationTester.assertEquals(this.values, descending);
    }
}

