/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractContainerTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRemoveTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRemove_duplicate() {
        AbstractContainerTester.ArrayWithDuplicate arrayAndDuplicate = this.createArrayWithDuplicateElement();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(arrayAndDuplicate.elements);
        Object duplicate = arrayAndDuplicate.duplicate;
        int firstIndex = this.getList().indexOf(duplicate);
        int initialSize = this.getList().size();
        ListRemoveTester.assertTrue((String)"remove(present) should return true", (boolean)this.getList().remove(duplicate));
        ListRemoveTester.assertTrue((String)"After remove(duplicate), a list should still contain the duplicate element", (boolean)this.getList().contains(duplicate));
        ListRemoveTester.assertFalse((String)"remove(duplicate) should remove the first instance of the duplicate element in the list", (firstIndex == this.getList().indexOf(duplicate) ? 1 : 0) != 0);
        ListRemoveTester.assertEquals((String)"remove(present) should decrease the size of a list by one.", (int)(initialSize - 1), (int)this.getList().size());
    }
}

