/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestCollidingSetGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.TestUnhashableCollectionGenerator;
import com.google.common.collect.testing.UnhashableObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class SetGenerators {
    private static Comparator<String> createExplicitComparator(String[] elements) {
        LinkedHashSet elementsPlus = Sets.newLinkedHashSet();
        elementsPlus.add("\u0000");
        elementsPlus.add("\u0000\u0000");
        elementsPlus.addAll(Arrays.asList(elements));
        elementsPlus.add("z");
        elementsPlus.add("zz");
        return Ordering.explicit((List)Lists.newArrayList((Iterable)elementsPlus));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TestUnhashableSetGenerator
    extends TestUnhashableCollectionGenerator<Set<UnhashableObject>>
    implements TestSetGenerator<UnhashableObject> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedsetSubsetAsListSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Comparator comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)comparator);
            builder.add((Object)"\u0000");
            builder.add((Object)"\u0000\u0000");
            builder.add((Object[])elements);
            builder.add((Object)"z");
            builder.add((Object)"zz");
            return builder.build().subSet((Object)"\u0000\u0000", (Object)"zz").asList().subList(1, elements.length + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetAsListSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Comparator comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)comparator);
            builder.add((Object)"\u0000");
            builder.add((Object[])elements);
            builder.add((Object)"z");
            return builder.build().asList().subList(1, elements.length + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetSubsetAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Comparator comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)comparator);
            builder.add((Object)"\u0000");
            builder.add((Object[])elements);
            builder.add((Object)"z");
            return builder.build().subSet((Object)"\u0000\u0000", (Object)"z").asList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Comparator comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparator)comparator, Arrays.asList(elements));
            return set.asList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSetAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            return ImmutableSet.copyOf((Object[])elements).asList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetUnhashableGenerator
    extends TestUnhashableSetGenerator {
        @Override
        public Set<UnhashableObject> create(UnhashableObject[] elements) {
            return ImmutableSortedSet.copyOf((Comparable[])elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetReversedOrderGenerator
    extends TestStringSetGenerator {
        protected SortedSet<String> create(String[] elements) {
            return ImmutableSortedSet.reverseOrder().addAll(Arrays.asList(elements).iterator()).build();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder, Collections.reverseOrder());
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetExplicitSuperclassComparatorGenerator
    extends TestStringSetGenerator {
        private static final Comparator<Comparable<?>> COMPARABLE_REVERSED = Collections.reverseOrder();

        protected SortedSet<String> create(String[] elements) {
            return new ImmutableSortedSet.Builder(COMPARABLE_REVERSED).add((Object[])elements).build();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder, Collections.reverseOrder());
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetExplicitComparator
    extends TestStringSetGenerator {
        private static final Comparator<String> STRING_REVERSED = Collections.reverseOrder();

        protected SortedSet<String> create(String[] elements) {
            return ImmutableSortedSet.orderedBy(STRING_REVERSED).add((Object[])elements).build();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder, Collections.reverseOrder());
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetSubsetGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            ArrayList list = Lists.newArrayList((Object[])elements);
            list.add("\u0000");
            list.add("zzz");
            return ImmutableSortedSet.copyOf((Collection)list).subSet((Object)"\u0000\u0000", (Object)"zzy");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetTailsetGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            ArrayList list = Lists.newArrayList((Object[])elements);
            list.add("\u0000");
            return ImmutableSortedSet.copyOf((Collection)list).tailSet((Object)"\u0000\u0000");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetHeadsetGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            ArrayList list = Lists.newArrayList((Object[])elements);
            list.add("zzz");
            return ImmutableSortedSet.copyOf((Collection)list).headSet((Object)"zzy");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSortedSetCopyOfGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            return ImmutableSortedSet.copyOf((Comparable[])elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DegeneratedImmutableSetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            return ImmutableSet.of((Object)elements[0], (Object)elements[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSetWithBadHashesGenerator
    extends TestCollidingSetGenerator
    implements TestCollectionGenerator<Object> {
        @Override
        public Set<Object> create(Object ... elements) {
            return ImmutableSet.copyOf((Object[])elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImmutableSetCopyOfGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            return ImmutableSet.copyOf((Object[])elements);
        }
    }
}

