/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.features;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.ConflictingRequirementsException;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.TesterAnnotation;
import com.google.common.collect.testing.features.TesterRequirements;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureUtil {
    private static Map<AnnotatedElement, Annotation[]> annotationCache = new HashMap<AnnotatedElement, Annotation[]>();
    private static final Map<Class<?>, TesterRequirements> classTesterRequirementsCache = new HashMap();

    public static Set<Feature<?>> addImpliedFeatures(Set<Feature<?>> features) {
        if (!features.isEmpty()) {
            features.addAll(FeatureUtil.impliedFeatures(features));
        }
        return features;
    }

    public static Set<Feature<?>> impliedFeatures(Set<Feature<?>> features) {
        LinkedHashSet implied = new LinkedHashSet();
        for (Feature<?> feature : features) {
            implied.addAll(feature.getImpliedFeatures());
        }
        FeatureUtil.addImpliedFeatures(implied);
        return implied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TesterRequirements getTesterRequirements(Class<?> testerClass) throws ConflictingRequirementsException {
        Map<Class<?>, TesterRequirements> map = classTesterRequirementsCache;
        synchronized (map) {
            TesterRequirements requirements = classTesterRequirementsCache.get(testerClass);
            if (requirements == null) {
                requirements = FeatureUtil.buildTesterRequirements(testerClass);
                classTesterRequirementsCache.put(testerClass, requirements);
            }
            return requirements;
        }
    }

    public static TesterRequirements getTesterRequirements(Method testerMethod) throws ConflictingRequirementsException {
        return FeatureUtil.buildTesterRequirements(testerMethod);
    }

    static TesterRequirements buildTesterRequirements(Class<?> testerClass) throws ConflictingRequirementsException {
        TesterRequirements declaredRequirements = FeatureUtil.buildDeclaredTesterRequirements(testerClass);
        Class<?> baseClass = testerClass.getSuperclass();
        if (baseClass == null) {
            return declaredRequirements;
        }
        TesterRequirements clonedBaseRequirements = new TesterRequirements(FeatureUtil.getTesterRequirements(baseClass));
        return FeatureUtil.incorporateRequirements(clonedBaseRequirements, declaredRequirements, testerClass);
    }

    static TesterRequirements buildTesterRequirements(Method testerMethod) throws ConflictingRequirementsException {
        TesterRequirements clonedClassRequirements = new TesterRequirements(FeatureUtil.getTesterRequirements(testerMethod.getDeclaringClass()));
        TesterRequirements declaredRequirements = FeatureUtil.buildDeclaredTesterRequirements(testerMethod);
        return FeatureUtil.incorporateRequirements(clonedClassRequirements, declaredRequirements, testerMethod);
    }

    public static TesterRequirements buildDeclaredTesterRequirements(AnnotatedElement classOrMethod) throws ConflictingRequirementsException {
        TesterRequirements requirements = new TesterRequirements();
        Iterable<Annotation> testerAnnotations = FeatureUtil.getTesterAnnotations(classOrMethod);
        for (Annotation testerAnnotation : testerAnnotations) {
            TesterRequirements moreRequirements = FeatureUtil.buildTesterRequirements(testerAnnotation);
            FeatureUtil.incorporateRequirements(requirements, moreRequirements, testerAnnotation);
        }
        return requirements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Annotation> getTesterAnnotations(AnnotatedElement classOrMethod) {
        Annotation[] annotations;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Map<AnnotatedElement, Annotation[]> map = annotationCache;
        synchronized (map) {
            annotations = annotationCache.get(classOrMethod);
            if (annotations == null) {
                annotations = classOrMethod.getDeclaredAnnotations();
                annotationCache.put(classOrMethod, annotations);
            }
        }
        for (Annotation a : annotations) {
            Class<? extends Annotation> annotationClass = a.annotationType();
            if (!annotationClass.isAnnotationPresent(TesterAnnotation.class)) continue;
            result.add(a);
        }
        return result;
    }

    private static TesterRequirements buildTesterRequirements(Annotation testerAnnotation) throws ConflictingRequirementsException {
        Feature[] absentFeatures;
        Feature[] presentFeatures;
        Class<?> annotationClass = testerAnnotation.getClass();
        try {
            presentFeatures = (Feature[])annotationClass.getMethod("value", new Class[0]).invoke((Object)testerAnnotation, new Object[0]);
            absentFeatures = (Feature[])annotationClass.getMethod("absent", new Class[0]).invoke((Object)testerAnnotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error extracting features from tester annotation.", e);
        }
        Set<Feature<?>> allPresentFeatures = FeatureUtil.addImpliedFeatures(Helpers.copyToSet(presentFeatures));
        Set<Feature<?>> allAbsentFeatures = FeatureUtil.addImpliedFeatures(Helpers.copyToSet(absentFeatures));
        Set<Feature<?>> conflictingFeatures = FeatureUtil.intersection(allPresentFeatures, allAbsentFeatures);
        if (!conflictingFeatures.isEmpty()) {
            throw new ConflictingRequirementsException("Annotation explicitly or implicitly requires one or more features to be both present and absent.", conflictingFeatures, testerAnnotation);
        }
        return new TesterRequirements(allPresentFeatures, allAbsentFeatures);
    }

    private static TesterRequirements incorporateRequirements(TesterRequirements requirements, TesterRequirements moreRequirements, Object source) throws ConflictingRequirementsException {
        Set<Feature<?>> presentFeatures = requirements.getPresentFeatures();
        Set<Feature<?>> absentFeatures = requirements.getAbsentFeatures();
        Set<Feature<?>> morePresentFeatures = moreRequirements.getPresentFeatures();
        Set<Feature<?>> moreAbsentFeatures = moreRequirements.getAbsentFeatures();
        FeatureUtil.checkConflict("absent", absentFeatures, "present", morePresentFeatures, source);
        FeatureUtil.checkConflict("present", presentFeatures, "absent", moreAbsentFeatures, source);
        presentFeatures.addAll(morePresentFeatures);
        absentFeatures.addAll(moreAbsentFeatures);
        return requirements;
    }

    private static void checkConflict(String earlierRequirement, Set<Feature<?>> earlierFeatures, String newRequirement, Set<Feature<?>> newFeatures, Object source) throws ConflictingRequirementsException {
        Set<Feature<?>> conflictingFeatures = FeatureUtil.intersection(newFeatures, earlierFeatures);
        if (!conflictingFeatures.isEmpty()) {
            throw new ConflictingRequirementsException(String.format("Annotation requires to be %s features that earlier annotations required to be %s.", newRequirement, earlierRequirement), conflictingFeatures, source);
        }
    }

    public static <T> Set<T> intersection(Set<? extends T> set1, Set<? extends T> set2) {
        return FeatureUtil.intersection(new Set[]{set1, set2});
    }

    public static <T> Set<T> intersection(Set<? extends T> ... sets) {
        if (sets.length == 0) {
            throw new IllegalArgumentException("Can't intersect no sets; would have to return the universe.");
        }
        Set<T> results = Helpers.copyToSet(sets[0]);
        for (int i = 1; i < sets.length; ++i) {
            Set<? extends T> set = sets[i];
            results.retainAll(set);
        }
        return results;
    }
}

