/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, Integer> countMap;
    private volatile transient EntrySet entrySet;
    private static final long serialVersionUID = 0L;

    public ConcurrentMultiset() {
        this(new ConcurrentHashMap());
    }

    public ConcurrentMultiset(Collection<? extends E> collection) {
        this(new ConcurrentHashMap(Maps.capacity(collection.size())));
        this.addAll(collection);
    }

    ConcurrentMultiset(ConcurrentMap<E, Integer> countMap) {
        Preconditions.checkArgument(countMap.isEmpty());
        this.countMap = countMap;
    }

    @Override
    public int count(@Nullable Object element) {
        try {
            return ConcurrentMultiset.unbox((Integer)this.countMap.get(element));
        }
        catch (NullPointerException e) {
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    @Override
    public int size() {
        long sum = 0L;
        for (Integer value : this.countMap.values()) {
            sum += (long)value.intValue();
        }
        return (int)Math.min(sum, Integer.MAX_VALUE);
    }

    @Override
    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.snapshot().toArray(array);
    }

    private List<E> snapshot() {
        ArrayList<E> list = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry<E> entry : this.entrySet()) {
            E element = entry.getElement();
            for (int i = entry.getCount(); i > 0; --i) {
                list.add(element);
            }
        }
        return list;
    }

    @Override
    public boolean add(E element, int occurrences) {
        if (occurrences == 0) {
            return false;
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        while (true) {
            int current;
            if ((current = this.count(element)) == 0) {
                if (this.countMap.putIfAbsent(element, occurrences) != null) continue;
                return true;
            }
            Preconditions.checkArgument(occurrences <= Integer.MAX_VALUE - current, "Overflow adding %s occurrences to a count of %s", occurrences, current);
            int next = current + occurrences;
            if (this.countMap.replace(element, current, next)) break;
        }
        return true;
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        if (occurrences == 0) {
            return 0;
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        while (true) {
            int current;
            if ((current = this.count(element)) == 0) {
                return 0;
            }
            if (occurrences >= current) {
                if (!this.countMap.remove(element, current)) continue;
                return current;
            }
            Object casted = element;
            if (this.countMap.replace(casted, current, current - occurrences)) break;
        }
        return occurrences;
    }

    @Override
    public int removeAllOccurrences(@Nullable Object element) {
        try {
            return ConcurrentMultiset.unbox((Integer)this.countMap.remove(element));
        }
        catch (NullPointerException e) {
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    public boolean removeExactly(@Nullable Object element, int occurrences) {
        Object casted;
        int current;
        if (occurrences == 0) {
            return true;
        }
        Preconditions.checkArgument(occurrences > 0, "Invalid occurrences: %s", occurrences);
        do {
            if (occurrences <= (current = this.count(element))) continue;
            return false;
        } while (!(occurrences == current ? this.countMap.remove(element, occurrences) : this.countMap.replace(casted = element, current, current - occurrences)));
        return true;
    }

    public int setCount(E element, int count) {
        Preconditions.checkArgument(count >= 0, "Invalid count: %s", count);
        return count == 0 ? this.removeAllOccurrences(element) : ConcurrentMultiset.unbox(this.countMap.put(element, count));
    }

    public boolean setCount(E element, int oldCount, int newCount) {
        Preconditions.checkArgument(oldCount >= 0, "Invalid oldCount: %s", oldCount);
        Preconditions.checkArgument(newCount >= 0, "Invalid newCount: %s", newCount);
        if (newCount == 0) {
            if (oldCount == 0) {
                return !this.countMap.containsKey(element);
            }
            return this.countMap.remove(element, oldCount);
        }
        if (oldCount == 0) {
            return this.countMap.putIfAbsent(element, newCount) == null;
        }
        return this.countMap.replace(element, oldCount, newCount);
    }

    @Override
    public Set<E> elementSet() {
        return this.countMap.keySet();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        EntrySet result = this.entrySet;
        if (result == null) {
            this.entrySet = result = new EntrySet();
        }
        return result;
    }

    private static int unbox(Integer i) {
        return i == null ? 0 : i;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(HashMultiset.create(this), stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException, NoSuchFieldException {
        stream.defaultReadObject();
        Serialization.setFinalField(ConcurrentMultiset.class, this, "countMap", Maps.newConcurrentHashMap());
        Serialization.populateMultiset(this, stream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Multiset.Entry<E>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ConcurrentMultiset.this.countMap.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMultiset.this.countMap.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object element = entry.getElement();
                int entryCount = entry.getCount();
                return entryCount > 0 && ConcurrentMultiset.this.count(element) == entryCount;
            }
            return false;
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            final Iterator backingIterator = ConcurrentMultiset.this.countMap.entrySet().iterator();
            return new Iterator<Multiset.Entry<E>>(){

                @Override
                public boolean hasNext() {
                    return backingIterator.hasNext();
                }

                @Override
                public Multiset.Entry<E> next() {
                    Map.Entry backingEntry = (Map.Entry)backingIterator.next();
                    return Multisets.immutableEntry(backingEntry.getKey(), (Integer)backingEntry.getValue());
                }

                @Override
                public void remove() {
                    backingIterator.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.snapshot().toArray(array);
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList list = Lists.newArrayListWithExpectedSize(this.size());
            for (Multiset.Entry entry : this) {
                list.add(entry);
            }
            return list;
        }

        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object element = entry.getElement();
                int entryCount = entry.getCount();
                return ConcurrentMultiset.this.countMap.remove(element, entryCount);
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return super.retainAll(Preconditions.checkNotNull(c));
        }

        @Override
        public void clear() {
            ConcurrentMultiset.this.countMap.clear();
        }

        @Override
        public int hashCode() {
            return ConcurrentMultiset.this.countMap.hashCode();
        }
    }
}

