/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.compiler.selectors.ElementSubsequentComparator;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsComparatorUtils;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.ListsComparator;
import java.util.ArrayList;
import java.util.List;

public class SimpleSelectorComparator
implements ListsComparator.ListMemberComparator<SimpleSelector> {
    private final SelectorsComparatorUtils utils;
    private final ElementSubsequentComparator elementSubsequentComparator;
    private final ListsComparator listsComparator = new ListsComparator();

    public SimpleSelectorComparator(ElementSubsequentComparator elementSubsequentComparator, SelectorsComparatorUtils utils) {
        this.utils = utils;
        this.elementSubsequentComparator = elementSubsequentComparator;
    }

    @Override
    public boolean equals(SimpleSelector first, SimpleSelector second) {
        if (!this.prefix(first, second)) {
            return false;
        }
        List<ElementSubsequent> firstSubsequent = first.getSubsequent();
        List<ElementSubsequent> secondSubsequent = second.getSubsequent();
        return firstSubsequent.size() == secondSubsequent.size();
    }

    @Override
    public boolean prefix(SimpleSelector lookFor, SimpleSelector inside) {
        if (!this.simpleSelectorsElementsEqual(lookFor, inside)) {
            return false;
        }
        List<ElementSubsequent> lookForSubsequent = lookFor.getSubsequent();
        List<ElementSubsequent> inSelectorSubsequent = inside.getSubsequent();
        return this.listsComparator.prefix(lookForSubsequent, inSelectorSubsequent, this.elementSubsequentComparator);
    }

    @Override
    public boolean suffix(SimpleSelector lookFor, SimpleSelector inside) {
        if (this.hasNoElement(lookFor)) {
            return this.listsComparator.suffix(lookFor.getSubsequent(), inside.getSubsequent(), this.elementSubsequentComparator);
        }
        return this.equals(lookFor, inside);
    }

    public SimpleSelector cutSuffix(SimpleSelector lookFor, SimpleSelector inside) {
        if (this.hasNoElement(lookFor)) {
            List<ElementSubsequent> lfSubsequent = lookFor.getSubsequent();
            List<ElementSubsequent> insideSubsequent = inside.getSubsequent();
            ListsComparator.MatchMarker<ElementSubsequent> match = this.listsComparator.suffixMatches(lfSubsequent, insideSubsequent, this.elementSubsequentComparator);
            return this.removeMatch(inside, insideSubsequent, match);
        }
        return null;
    }

    private SimpleSelector removeMatch(SimpleSelector owner, List<ElementSubsequent> subsequentsList, ListsComparator.MatchMarker<ElementSubsequent> match) {
        if (match == null) {
            return owner;
        }
        if (this.hasNoElement(owner) && match.getFirst() == subsequentsList.get(0) && match.getLast() == ArraysUtils.last(subsequentsList)) {
            return null;
        }
        int indexOfFirst = subsequentsList.indexOf(match.getFirst());
        int indexOfLast = subsequentsList.indexOf(match.getFirst());
        List<ElementSubsequent> subList = subsequentsList.subList(indexOfFirst, indexOfLast + 1);
        for (ElementSubsequent elementSubsequent : subList) {
            elementSubsequent.setParent(null);
        }
        subList.removeAll(subList);
        return owner;
    }

    public SimpleSelector cutPrefix(SimpleSelector lookFor, SimpleSelector inside) {
        inside.setStar(true);
        inside.setEmptyForm(true);
        if (inside.hasElement()) {
            inside.getElementName().setParent(null);
        }
        inside.setElementName(null);
        List<ElementSubsequent> lfSubsequent = lookFor.getSubsequent();
        List<ElementSubsequent> insideSubsequent = inside.getSubsequent();
        ListsComparator.MatchMarker<ElementSubsequent> match = this.listsComparator.prefixMatches(lfSubsequent, insideSubsequent, this.elementSubsequentComparator);
        return this.removeMatch(inside, insideSubsequent, match);
    }

    private boolean hasNoElement(SimpleSelector selector) {
        return selector.isStar() && selector.isEmptyForm();
    }

    private boolean simpleSelectorsElementsEqual(SimpleSelector first, SimpleSelector second) {
        if (first.isStar() != second.isStar()) {
            return false;
        }
        if (first.isEmptyForm() != second.isEmptyForm()) {
            return false;
        }
        if (!this.combinatorsEqual(first.getLeadingCombinator(), second.getLeadingCombinator())) {
            return false;
        }
        return this.utils.interpolableNamesEqual(first.getElementName(), second.getElementName());
    }

    private boolean combinatorsEqual(SelectorCombinator cmb1, SelectorCombinator cmb2) {
        if (cmb1 == null) {
            return cmb2 == null || cmb2.getCombinator() == SelectorCombinator.Combinator.DESCENDANT;
        }
        if (cmb2 == null) {
            return cmb1 == null || cmb1.getCombinator() == SelectorCombinator.Combinator.DESCENDANT;
        }
        return cmb1.getCombinator() == cmb2.getCombinator();
    }

    @Override
    public boolean contains(SimpleSelector lookFor, SimpleSelector inside) {
        if (this.hasNoElement(lookFor)) {
            return this.listsComparator.contains(lookFor.getSubsequent(), inside.getSubsequent(), this.elementSubsequentComparator);
        }
        return this.prefix(lookFor, inside);
    }

    public SimpleSelector[] splitOn(SimpleSelector lookFor, SimpleSelector inside) {
        if (this.hasNoElement(lookFor)) {
            List<ListsComparator.MatchMarker<ElementSubsequent>> matches = this.listsComparator.findMatches(lookFor.getSubsequent(), inside.getSubsequent(), this.elementSubsequentComparator);
            List<ElementSubsequent> tail = this.splitAfter(matches.get(0).getLast(), inside.getSubsequent());
            this.removeMatch(inside, inside.getSubsequent(), matches.get(0));
            SimpleSelector second = new SimpleSelector(inside.getUnderlyingStructure(), null, null, true);
            second.setEmptyForm(true);
            second.addSubsequent(tail);
            return new SimpleSelector[]{inside, second};
        }
        return new SimpleSelector[]{null, this.cutPrefix(lookFor, inside)};
    }

    private List<ElementSubsequent> splitAfter(ElementSubsequent element, List<ElementSubsequent> list) {
        int indx = list.indexOf(element) + 1;
        if (indx == -1) {
            indx = list.size();
        }
        List<ElementSubsequent> subList = list.subList(indx, list.size());
        ArrayList<ElementSubsequent> result = new ArrayList<ElementSubsequent>(subList);
        subList.clear();
        return result;
    }
}

