/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.compiler.selectors.ElementSubsequentComparator;
import com.github.sommeri.less4j.core.compiler.selectors.GeneralComparatorForExtend;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorPartComparator;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorPartsListBuilder;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsComparatorUtils;
import com.github.sommeri.less4j.core.compiler.selectors.SimpleSelectorComparator;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.ListsComparator;
import java.util.List;

public class SelectorsComparatorForExtend {
    private SelectorsComparatorUtils utils = new SelectorsComparatorUtils();
    private ListsComparator listsComparator = new ListsComparator();
    private ElementSubsequentComparator elementSubsequentComparator;
    private SimpleSelectorComparator simpleSelectorComparator;
    private SelectorPartComparator selectorPartsComparator;

    public SelectorsComparatorForExtend(GeneralComparatorForExtend generalComparator) {
        this.elementSubsequentComparator = new ElementSubsequentComparator(generalComparator, this.utils);
        this.simpleSelectorComparator = new SimpleSelectorComparator(this.elementSubsequentComparator, this.utils);
        this.selectorPartsComparator = new SelectorPartComparator(this.simpleSelectorComparator);
    }

    public boolean equals(Selector first, Selector second) {
        List<SelectorPart> firstParts = first.getParts();
        List<SelectorPart> secondParts = second.getParts();
        return this.listsComparator.equals(firstParts, secondParts, this.selectorPartsComparator);
    }

    public boolean contains(Selector lookFor, Selector inSelector) {
        List<SelectorPart> inSelectorParts;
        List<SelectorPart> lookForParts = lookFor.getParts();
        return this.containsInList(lookForParts, inSelectorParts = inSelector.getParts()) || this.containsEmbedded(lookForParts, inSelectorParts);
    }

    public Selector replace(Selector lookFor, Selector inSelector, Selector replaceBy) {
        List<SelectorPart> lookForParts = lookFor.getParts();
        List<SelectorPart> inSelectorParts = ArraysUtils.deeplyClonedList(inSelector.getParts());
        Selector result = new Selector(inSelector.getUnderlyingStructure(), inSelectorParts);
        this.replaceInList(lookForParts, result, replaceBy.getParts());
        return result;
    }

    private boolean containsInList(List<SelectorPart> lookForParts, List<SelectorPart> inSelectorParts) {
        boolean contains = this.listsComparator.contains(lookForParts, inSelectorParts, this.selectorPartsComparator);
        return contains;
    }

    private Selector replaceInList(List<SelectorPart> lookForParts, Selector inSelector, List<SelectorPart> originalReplaceBy) {
        List<SelectorPart> inSelectorParts = inSelector.getParts();
        SelectorPartsListBuilder builder = new SelectorPartsListBuilder();
        List<ListsComparator.MatchMarker<SelectorPart>> matches = this.listsComparator.findMatches(lookForParts, inSelectorParts, this.selectorPartsComparator);
        if (matches.isEmpty() || originalReplaceBy == null || originalReplaceBy.isEmpty()) {
            return null;
        }
        for (ListsComparator.MatchMarker<SelectorPart> currentMatch : matches) {
            SelectorPart firstMatch = currentMatch.getFirst();
            SelectorPart lastMatch = currentMatch.getLast();
            List<SelectorPart> replaceBy = ArraysUtils.deeplyClonedList(originalReplaceBy);
            if (firstMatch == lastMatch) {
                if (lookForParts.size() != 1) {
                    throw new BugHappened("Impossible state happened.", lookForParts.isEmpty() ? null : lookForParts.get(0));
                }
                List<SelectorPart> replaceInside = this.replaceInsidePart(lookForParts.get(0), lastMatch, replaceBy);
                ArraysUtils.replace(lastMatch, inSelectorParts, replaceInside);
                inSelector.configureParentToAllChilds();
                return inSelector;
            }
            builder.addUpTo(inSelectorParts, firstMatch);
            ArraysUtils.chopFirst(inSelectorParts);
            SelectorPart firstRemainder = this.selectorPartsComparator.cutSuffix(lookForParts.get(0), firstMatch);
            if (firstRemainder != null) {
                builder.add(firstRemainder);
                builder.directlyAttach(replaceBy);
            } else {
                builder.addAll(replaceBy);
            }
            this.removeFromParent(ArraysUtils.chopUpTo(inSelectorParts, lastMatch));
            ArraysUtils.chopFirst(inSelectorParts);
            SelectorPart lastRemainder = this.selectorPartsComparator.cutPrefix(ArraysUtils.last(lookForParts), lastMatch);
            builder.directlyAttachNonNull(lastRemainder);
            builder.addAll(inSelectorParts);
        }
        inSelector.setParts(builder.getParts());
        inSelector.configureParentToAllChilds();
        return inSelector;
    }

    private List<SelectorPart> replaceInsidePart(SelectorPart lookFor, SelectorPart inside, List<SelectorPart> replaceBy) {
        SelectorPart[] split = this.selectorPartsComparator.splitOn(lookFor, inside);
        SelectorPartsListBuilder builder = new SelectorPartsListBuilder();
        if (split.length > 0) {
            builder.directlyAttachNonNull(split[0]);
            for (int i = 1; i < split.length; ++i) {
                builder.directlyAttach(ArraysUtils.deeplyClonedList(replaceBy));
                builder.directlyAttachNonNull(split[i]);
            }
        }
        return builder.getParts();
    }

    private void removeFromParent(List<SelectorPart> removeThese) {
        for (SelectorPart elementSubsequent : removeThese) {
            elementSubsequent.setParent(null);
        }
        removeThese.clear();
    }

    private boolean containsEmbedded(List<SelectorPart> lookFor, List<SelectorPart> inSelectors) {
        for (SelectorPart inside : inSelectors) {
            if (!this.containsEmbedded(lookFor, inside)) continue;
            return true;
        }
        return false;
    }

    private boolean containsEmbedded(List<SelectorPart> lookFor, ASTCssNode inside) {
        block3: for (ASTCssNode aSTCssNode : inside.getChilds()) {
            switch (aSTCssNode.getType()) {
                case SELECTOR: {
                    Selector kidSelector = (Selector)aSTCssNode;
                    if (!this.containsInList(lookFor, kidSelector.getParts())) continue block3;
                    return true;
                }
            }
            if (!this.containsEmbedded(lookFor, aSTCssNode)) continue;
            return true;
        }
        return false;
    }
}

