/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.compiler.selectors.ElementSubsequentComparator;
import com.github.sommeri.less4j.core.compiler.selectors.GeneralComparatorForExtend;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorPartComparator;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsComparatorUtils;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsManipulator;
import com.github.sommeri.less4j.core.compiler.selectors.SimpleSelectorComparator;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.ListsComparator;
import java.util.ArrayList;
import java.util.List;

public class Old_SelectorsComparatorForExtend {
    private SelectorsManipulator manipulator = new SelectorsManipulator();
    private SelectorsComparatorUtils utils = new SelectorsComparatorUtils();
    private ListsComparator listsComparator = new ListsComparator();
    private ElementSubsequentComparator elementSubsequentComparator;
    private SimpleSelectorComparator simpleSelectorComparator;
    private SelectorPartComparator selectorPartsComparator;

    public Old_SelectorsComparatorForExtend(GeneralComparatorForExtend generalComparator) {
        this.elementSubsequentComparator = new ElementSubsequentComparator(generalComparator, this.utils);
        this.simpleSelectorComparator = new SimpleSelectorComparator(this.elementSubsequentComparator, this.utils);
        this.selectorPartsComparator = new SelectorPartComparator(this.simpleSelectorComparator);
    }

    public boolean equals(Selector first, Selector second) {
        List<SelectorPart> firstParts = first.getParts();
        List<SelectorPart> secondParts = second.getParts();
        return this.listsComparator.equals(firstParts, secondParts, this.selectorPartsComparator);
    }

    public boolean contains(Selector lookFor, Selector inSelector) {
        List<SelectorPart> inSelectorParts;
        List<SelectorPart> lookForParts = lookFor.getParts();
        return this.containsInList(lookForParts, inSelectorParts = inSelector.getParts()) || this.containsEmbedded(lookForParts, inSelectorParts);
    }

    public Selector replace(Selector lookFor, Selector inSelector, Selector replaceBy) {
        List<SelectorPart> lookForParts = lookFor.getParts();
        List<SelectorPart> inSelectorParts = ArraysUtils.deeplyClonedList(inSelector.getParts());
        Selector result = new Selector(inSelector.getUnderlyingStructure(), inSelectorParts);
        this.replaceInList(lookForParts, result, replaceBy.getParts());
        return result;
    }

    private boolean containsInList(List<SelectorPart> lookForParts, List<SelectorPart> inSelectorParts) {
        boolean contains = this.listsComparator.contains(lookForParts, inSelectorParts, this.selectorPartsComparator);
        return contains;
    }

    private Selector replaceInList(List<SelectorPart> lookForParts, Selector inSelector, List<SelectorPart> replaceBy) {
        SelectorPart lastRemainder;
        List<SelectorPart> inSelectorParts = inSelector.getParts();
        ArrayList newInSelectorParts = new ArrayList();
        List<ListsComparator.MatchMarker<SelectorPart>> matches = this.listsComparator.findMatches(lookForParts, inSelectorParts, this.selectorPartsComparator);
        if (matches.isEmpty() || replaceBy == null || replaceBy.isEmpty()) {
            return null;
        }
        lookForParts = ArraysUtils.deeplyClonedList(lookForParts);
        replaceBy = ArraysUtils.deeplyClonedList(replaceBy);
        List<SelectorPart> newBeginning = null;
        List<SelectorPart> newEnding = null;
        List<SelectorPart> removeThese = null;
        SelectorPart firstMatch = matches.get(0).getFirst();
        SelectorPart lastMatch = matches.get(0).getLast();
        int firstIndex = inSelectorParts.indexOf(firstMatch);
        SelectorPart firstRemainder = this.selectorPartsComparator.cutSuffix(lookForParts.get(0), firstMatch);
        if (firstRemainder != null) {
            ++firstIndex;
            SelectorPart firstReplaceBy = replaceBy.remove(0);
            this.manipulator.directlyJoinParts(firstRemainder, firstReplaceBy);
        }
        newBeginning = inSelectorParts.subList(0, firstIndex);
        int lastIndex = inSelectorParts.indexOf(lastMatch);
        SelectorPart selectorPart = lastRemainder = lastMatch == firstMatch ? null : this.selectorPartsComparator.cutPrefix(ArraysUtils.last(lookForParts), lastMatch);
        if (lastRemainder != null) {
            if (replaceBy.isEmpty()) {
                this.manipulator.directlyJoinParts(firstRemainder, lastRemainder);
            } else {
                SelectorPart lastReplaceBy = ArraysUtils.last(replaceBy);
                this.manipulator.directlyJoinParts(lastReplaceBy, lastRemainder);
            }
        }
        removeThese = this.sublistCopy(inSelectorParts, firstIndex, ++lastIndex);
        newEnding = this.sublistCopy(inSelectorParts, lastIndex, inSelectorParts.size());
        this.removeFromParent(removeThese);
        List<SelectorPart> newParts = ArraysUtils.joinAll(newBeginning, replaceBy, newEnding);
        inSelector.setParts(newParts);
        inSelector.configureParentToAllChilds();
        return inSelector;
    }

    private void removeFromParent(List<SelectorPart> removeThese) {
        for (SelectorPart elementSubsequent : removeThese) {
            elementSubsequent.setParent(null);
        }
        removeThese.clear();
    }

    private List<SelectorPart> sublistCopy(List<SelectorPart> list, int first, int last) {
        return first > last ? new ArrayList<SelectorPart>() : new ArrayList<SelectorPart>(list.subList(first, last));
    }

    private boolean containsEmbedded(List<SelectorPart> lookFor, List<SelectorPart> inSelectors) {
        for (SelectorPart inside : inSelectors) {
            if (!this.containsEmbedded(lookFor, inside)) continue;
            return true;
        }
        return false;
    }

    private boolean containsEmbedded(List<SelectorPart> lookFor, ASTCssNode inside) {
        block3: for (ASTCssNode aSTCssNode : inside.getChilds()) {
            switch (aSTCssNode.getType()) {
                case SELECTOR: {
                    Selector kidSelector = (Selector)aSTCssNode;
                    if (!this.containsInList(lookFor, kidSelector.getParts())) continue block3;
                    return true;
                }
            }
            if (!this.containsEmbedded(lookFor, aSTCssNode)) continue;
            return true;
        }
        return false;
    }
}

