/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.AlreadyExtended;
import com.github.sommeri.less4j.core.compiler.selectors.GeneralComparatorForExtend;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendsSolver {
    private GeneralComparatorForExtend comparator = new GeneralComparatorForExtend();
    private ASTManipulator manipulator = new ASTManipulator();
    private List<RuleSet> allRulesets = new ArrayList<RuleSet>();
    private List<Selector> inlineExtends = new ArrayList<Selector>();
    private Map<Selector, List<Selector>> allSelectorExtends = new HashMap<Selector, List<Selector>>();

    public void solveExtends(ASTCssNode node) {
        this.collectRulesets(node);
        this.solveInlineExtends();
    }

    private void solveInlineExtends() {
        for (Selector selector : this.inlineExtends) {
            this.solveInlineExtends(selector);
        }
    }

    private void solveInlineExtends(Selector extendingSelector) {
        AlreadyExtended alreadyExtended = new AlreadyExtended();
        alreadyExtended.markAsAlreadyExtended(extendingSelector, (RuleSet)extendingSelector.getParent());
        for (RuleSet ruleSet : this.allRulesets) {
            ArrayList<Selector> selectors = new ArrayList<Selector>(ruleSet.getSelectors());
            for (Selector targetSelector : selectors) {
                Selector shouldExtendAsAll;
                if (this.shouldExtendAsFull(extendingSelector, targetSelector) && this.canExtend(extendingSelector, alreadyExtended, ruleSet)) {
                    this.doTheExtend(extendingSelector, alreadyExtended, ruleSet, targetSelector);
                }
                if ((shouldExtendAsAll = this.shouldExtendAsAll(extendingSelector, targetSelector)) == null) continue;
                this.doTheExtend(shouldExtendAsAll, alreadyExtended, ruleSet, targetSelector);
            }
        }
    }

    private void doTheExtend(Selector extendingSelector, AlreadyExtended alreadyExtended, RuleSet ruleSet, Selector targetSelector) {
        this.performExtend(extendingSelector, ruleSet);
        this.addToThoseWhoExtended(extendingSelector, targetSelector);
        alreadyExtended.markAsAlreadyExtended(extendingSelector, ruleSet);
        ArrayList<Selector> thoseWhoExtendedExtending = new ArrayList<Selector>(this.getThoseWhoExtended(extendingSelector));
        for (Selector extendedExtending : thoseWhoExtendedExtending) {
            if (!this.canExtend(extendedExtending, alreadyExtended, ruleSet)) continue;
            this.doTheExtend(extendedExtending, alreadyExtended, ruleSet, targetSelector);
        }
    }

    private boolean canExtend(Selector extendingSelector, AlreadyExtended alreadyExtended, RuleSet targetRuleSet) {
        if (alreadyExtended.alreadyExtended(extendingSelector, targetRuleSet)) {
            return false;
        }
        if (this.containsSelector(extendingSelector, targetRuleSet)) {
            return false;
        }
        return this.compatibleMediaLocation(extendingSelector, targetRuleSet);
    }

    private boolean compatibleMediaLocation(Selector extendingSelector, RuleSet targetRuleSet) {
        ASTCssNode grandParent = this.findOwnerNode(extendingSelector);
        if (grandParent == null || grandParent.getType() == ASTCssNodeType.STYLE_SHEET) {
            return true;
        }
        return grandParent == this.findOwnerNode(targetRuleSet);
    }

    private boolean containsSelector(Selector extendingSelector, RuleSet targetRuleSet) {
        for (Selector selector : targetRuleSet.getSelectors()) {
            if (!this.comparator.equals(selector, extendingSelector)) continue;
            return true;
        }
        return false;
    }

    private ASTCssNode findOwnerNode(ASTCssNode extendingSelector) {
        return this.manipulator.findParentOfType(extendingSelector, ASTCssNodeType.STYLE_SHEET, ASTCssNodeType.MEDIA);
    }

    private void performExtend(Selector extendingSelector, RuleSet ruleSet) {
        Selector selectorClone = extendingSelector.clone();
        selectorClone.setParent(ruleSet);
        ruleSet.addSelector(selectorClone);
    }

    private void addToThoseWhoExtended(Selector extendingSelector, Selector targetSelector) {
        List<Selector> tied = this.getThoseWhoExtended(targetSelector);
        tied.add(extendingSelector);
    }

    private List<Selector> getThoseWhoExtended(Selector selector) {
        List<Selector> result = this.allSelectorExtends.get(selector);
        if (result == null) {
            result = new ArrayList<Selector>();
            this.allSelectorExtends.put(selector, result);
        }
        return result;
    }

    private boolean shouldExtendAsFull(Selector extending, Selector possibleTarget) {
        if (possibleTarget == extending) {
            return false;
        }
        List<Extend> extendds = extending.getExtend();
        for (Extend extend : extendds) {
            if (extend.isAll() || !this.comparator.equals(possibleTarget, extend.getTarget())) continue;
            return true;
        }
        return false;
    }

    private Selector shouldExtendAsAll(Selector extending, Selector possibleTarget) {
        if (possibleTarget == extending) {
            return null;
        }
        List<Extend> extendds = extending.getExtend();
        for (Extend extend : extendds) {
            if (!extend.isAll()) continue;
            Selector addSelector = this.comparator.replaceInside(extend.getTarget(), possibleTarget, extend.getParentAsSelector());
            return addSelector;
        }
        return null;
    }

    private void collectRulesets(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                RuleSet ruleset = (RuleSet)node;
                this.allRulesets.add(ruleset);
                this.collectAllSelectors(ruleset);
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.collectRulesets(aSTCssNode);
                }
            }
        }
    }

    private void collectAllSelectors(RuleSet ruleset) {
        for (Selector selector : ruleset.getSelectors()) {
            if (!selector.isExtending()) continue;
            this.inlineExtends.add(selector);
        }
    }
}

