/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.geo.mem;

import com.github.davidmoten.geo.Base32;
import com.github.davidmoten.geo.Coverage;
import com.github.davidmoten.geo.GeoHash;
import com.github.davidmoten.geo.mem.Info;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class Geomem<T, R> {
    private final Map<Long, SortedMap<Long, Info<T, R>>> mapByGeoHash = Maps.newConcurrentMap();
    private final Map<R, Map<Long, SortedMap<Long, Info<T, R>>>> mapById = Maps.newConcurrentMap();

    public Iterable<Info<T, R>> find(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon, long start, long finish) {
        Coverage cover = GeoHash.coverBoundingBox(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon);
        Iterable<Info<T, R>> it = Collections.emptyList();
        for (String hash : cover.getHashes()) {
            it = Iterables.concat(it, this.find(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon, start, finish, hash));
        }
        return it;
    }

    private Iterable<Info<T, R>> find(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon, long start, long finish, String withinHash) {
        Iterable<Info<T, R>> it = this.find(start, finish, withinHash);
        return Iterables.filter(it, this.createRegionFilter(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon));
    }

    @VisibleForTesting
    Predicate<Info<T, R>> createRegionFilter(final double topLeftLat, final double topLeftLon, final double bottomRightLat, final double bottomRightLon) {
        return new Predicate<Info<T, R>>(){

            public boolean apply(Info<T, R> info) {
                return info.lat() >= bottomRightLat && info.lat() < topLeftLat && info.lon() > topLeftLon && info.lon() <= bottomRightLon;
            }
        };
    }

    private Iterable<Info<T, R>> find(long start, long finish, String withinHash) {
        long key = Base32.decodeBase32(withinHash);
        SortedMap<Long, Info<T, R>> sortedByTime = this.mapByGeoHash.get(key);
        if (sortedByTime == null) {
            return Collections.emptyList();
        }
        return sortedByTime.subMap(start, finish).values();
    }

    public void add(double lat, double lon, long time, T t) {
        this.add(lat, lon, time, t, Optional.of(t));
    }

    public void add(double lat, double lon, long time, T t, R id) {
        this.add(lat, lon, time, t, Optional.of(id));
    }

    public void add(double lat, double lon, long time, T t, Optional<R> id) {
        Info<T, R> info = new Info<T, R>(lat, lon, time, t, id);
        this.add(info);
    }

    public void add(Info<T, R> info) {
        String hash = GeoHash.encodeHash(info.lat(), info.lon());
        this.addToMap(this.mapByGeoHash, info, hash);
        this.addToMapById(this.mapById, info, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMapById(Map<R, Map<Long, SortedMap<Long, Info<T, R>>>> mapById, Info<T, R> info, String hash) {
        if (info.id().isPresent()) {
            ConcurrentMap m = mapById.get(info.id().get());
            Map<Long, SortedMap<Long, Info<T, R>>> map = this.mapByGeoHash;
            synchronized (map) {
                if (m == null) {
                    m = Maps.newConcurrentMap();
                    mapById.put(info.id().get(), m);
                }
            }
            this.addToMap(m, info, hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(Map<Long, SortedMap<Long, Info<T, R>>> map, Info<T, R> info, String hash) {
        for (int i = 1; i <= hash.length(); ++i) {
            long key = Base32.decodeBase32(hash.substring(0, i));
            Map<Long, SortedMap<Long, Info<T, R>>> map2 = map;
            synchronized (map2) {
                if (map.get(key) == null) {
                    map.put(key, new ConcurrentSkipListMap());
                }
            }
            map.get(key).put(info.time(), info);
        }
    }
}

