/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import java.util.Collection;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class Validator {
    private static final String REGEX_CAMEL_NODE_NAME_MATCH = "^[A-Za-z0-9-_]*[A-Za-z0-9][A-Za-z0-9-_]*$";
    private static final String REGEX_CAMEL_NODE_NAME_NORMALIZE = "[^A-Za-z0-9-_]";
    private static final String REGEX_ZOO_KEEPER_NODE_NAME_MATCH = "[^/]*";
    private static final String REGEX_ZOO_KEEPER_NODE_NAME_NORMALIZE = "[/]";
    private static final String REGEX_URI_MATCH = "^[a-zA-Z0-9_\\.-]{1}[a-zA-Z0-9-_/&?\\.=~%()<>]*(\\s*[a-zA-Z0-9-_/&?=\\.~%()<>]+)+";
    private static final Pattern REGEX_REPLACEMENT_TOKEN_MATCH = Pattern.compile("\\$\\{(.+?)\\}");
    private static final String BAD_CHARACTERS_FOR_GED_FIELD_NAME = "$.[]?*<>!={}%()";
    private static final String BAD_CHARACTERS_FOR_TAG_NAME = "$.[]?*<>!={}%";
    private static final String BAD_CHARACTERS_FOR_FIELD_EXPRESSION_TERM = "$";
    private static final char[] BAD_CHARACTERS_FOR_SERVICE_NAMES = new char[]{'#', '$', '%', '^', '*', '=', '`', '{', '}', '[', ']', ',', ' ', ':', '*', '?', '\"', '<', '>', '|', '\\', '/'};
    private static final char[] BAD_CHARACTERS_FOR_DATASOURCE_NAMES = new char[]{'#', '$', '%', '^', '*', '=', '`', '{', '}', '[', ']', ',', ' ', ':', '*', '?', '\"', '<', '>', '|', '\\', '/'};

    private static String normalizeZooKeeperNodeName(String name) {
        return !Validator.isBlank(name) ? name.replaceAll(REGEX_ZOO_KEEPER_NODE_NAME_NORMALIZE, "_") : name;
    }

    private static boolean isValidZooKeeperNodeName(String name) {
        return !Validator.isBlank(name) && name.matches(REGEX_ZOO_KEEPER_NODE_NAME_MATCH);
    }

    private static boolean isValidCamelNodeName(String name) {
        return !Validator.isBlank(name) && name.matches(REGEX_CAMEL_NODE_NAME_MATCH);
    }

    private static String normalizeEnglishName(String name) {
        return !Validator.isEmpty(name) ? name.replaceAll(REGEX_CAMEL_NODE_NAME_NORMALIZE, "_") : name;
    }

    private static boolean containsBadChar(String value, String badChars) {
        int length = badChars.length();
        for (int i = 0; i < length; ++i) {
            char badChar = badChars.charAt(i);
            if (value.indexOf(badChar) <= -1) continue;
            return true;
        }
        return false;
    }

    public static String normalizeAgsLayerName(String name) {
        return Validator.normalizeEnglishName(name);
    }

    public static String normalizeRssFeedName(String name) {
        return Validator.normalizeEnglishName(name);
    }

    public static String normalizeESIndexTypeName(String name) {
        if (Validator.isNotBlank(name) && name.startsWith("_")) {
            return name.replaceFirst("_", ".");
        }
        return name;
    }

    public static String compactSpaces(String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("  ", " ");
        String[] parts = value.split(" ");
        StringBuffer sb = new StringBuffer();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static String compactWhiteSpaces(String value) {
        String strippedValue = Validator.compactSpaces(value);
        return strippedValue.trim();
    }

    public static String compactSpaces(String value, String defaultValue) {
        return (value = Validator.compactSpaces(value)).length() == 0 ? defaultValue : value;
    }

    public static String compactWhiteSpaces(String value, String defaultValue) {
        return (value = Validator.compactWhiteSpaces(value)).length() == 0 ? defaultValue : value;
    }

    public static String normalizeToEmpty(String value) {
        return value == null ? "" : value;
    }

    public static String[] normalizeToEmpty(String[] arr) {
        return arr == null ? new String[]{} : arr;
    }

    public static <T extends Enum<T>> T valueOfIgnoreCase(Class<T> enumType, String name, T defaultValue) {
        if (!Validator.isEmpty(name)) {
            for (Enum constant : (Enum[])enumType.getEnumConstants()) {
                if (!constant.toString().equalsIgnoreCase(name)) continue;
                return (T)constant;
            }
        }
        return defaultValue;
    }

    public static String normalizeRegEx(String regex) {
        if ((regex = Validator.compactWhiteSpaces(regex)).isEmpty()) {
            return ".*";
        }
        try {
            Pattern.compile(regex);
        }
        catch (Throwable e) {
            regex = ".*";
        }
        return regex;
    }

    public static String normalizeGeoFencePattern(String pattern) {
        String stripped = Validator.normalizeToEmpty(pattern);
        return stripped.equals("*") ? ".*" : stripped;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !Validator.isEmpty(collection);
    }

    public static boolean isEmpty(CharSequence value) {
        return StringUtils.isEmpty((CharSequence)value);
    }

    public static boolean isNotEmpty(CharSequence value) {
        return StringUtils.isNotEmpty((CharSequence)value);
    }

    public static boolean isBlank(CharSequence value) {
        return StringUtils.isBlank((CharSequence)value);
    }

    public static boolean isNotBlank(CharSequence value) {
        return StringUtils.isNotBlank((CharSequence)value);
    }

    public static String normalizeLabel(String label, String name) {
        if (!Validator.isBlank(label)) {
            return label;
        }
        if (Validator.isBlank(name)) {
            return UUID.randomUUID().toString();
        }
        return name;
    }

    public static String normalizeGeoFenceName(String name) {
        return Validator.normalizeZooKeeperNodeName(name);
    }

    public static boolean isValidUri(String uri) {
        return !Validator.isEmpty(uri) && uri.matches(REGEX_URI_MATCH);
    }

    public static boolean isValidStreamName(String name) {
        return Validator.isValidCamelNodeName(name);
    }

    public static boolean isValidGeoFenceName(String name) {
        return Validator.isValidZooKeeperNodeName(name);
    }

    public static boolean isValidFolderDataStoreName(String name) {
        return Validator.isValidZooKeeperNodeName(name);
    }

    public static boolean isValidConnectionDataStoreName(String name) {
        return Validator.isValidZooKeeperNodeName(name);
    }

    public static boolean isValidFieldDefinitionName(String name) {
        return StringUtils.isNotEmpty((CharSequence)name) && !Validator.containsBadChar(name, BAD_CHARACTERS_FOR_GED_FIELD_NAME);
    }

    public static boolean isValidFieldExpressionTerm(String name) {
        return StringUtils.isNotEmpty((CharSequence)name) && !Validator.containsBadChar(name, BAD_CHARACTERS_FOR_FIELD_EXPRESSION_TERM);
    }

    public static boolean isValidTagName(String name) {
        if (Validator.containsBadChar(name, BAD_CHARACTERS_FOR_TAG_NAME)) {
            return false;
        }
        return Validator.isValidZooKeeperNodeName(name);
    }

    public static boolean isValidGeoFenceSyncName(String name) {
        return Validator.isValidZooKeeperNodeName(name);
    }

    public static boolean isValidGeoEventDefinitionName(String name) {
        return !name.contains("*");
    }

    public static boolean isValidPropertyName(String name) {
        return !name.contains("*");
    }

    public static boolean isValidServiceName(String serviceName) {
        return StringUtils.isNotEmpty((CharSequence)serviceName) && !Validator.containsBadChar(serviceName, new String(BAD_CHARACTERS_FOR_SERVICE_NAMES));
    }

    public static boolean isValidDataSourceName(String dataSourceName) {
        return StringUtils.isNotEmpty((CharSequence)dataSourceName) && !Validator.containsBadChar(dataSourceName, new String(BAD_CHARACTERS_FOR_DATASOURCE_NAMES));
    }

    public static boolean hasReplacementToken(String s) {
        return s != null && !s.isEmpty() ? REGEX_REPLACEMENT_TOKEN_MATCH.matcher(s).find() : false;
    }

    public static boolean isMatchingAllRegExPattern(String s) {
        return ".*".equals(s);
    }

    public static void main(String[] args) {
        boolean res = Validator.isValidCamelNodeName("$RECEIVED_TIME");
        res = Validator.isValidCamelNodeName("RECEIVED_$_TIME");
        res = Validator.isValidCamelNodeName("RECEIVED_TIME_$");
        res = Validator.isValidCamelNodeName("a.b.c.$RECEIVED_TIME");
        res = Validator.isValidCamelNodeName("a.b.c.myFieldName");
        res = Validator.isValidCamelNodeName("my$Field$Name");
        res = Validator.isValidTagName("abcd \u05e9\u05dc\u05d5\u05dd \u05e2\u05d5\u05dc\u05dd");
        res = Validator.isValidTagName("abcd \u05e2\u05d5\u05dc\u05dd");
        res = Validator.isValidTagName("ab(2)");
        res = Validator.isValidTagName("ab[2]");
        res = Validator.isValidTagName("a.b");
        res = Validator.isValidTagName("ab,");
        res = Validator.isValidTagName("a<b");
        res = Validator.isValidTagName("ab");
        res = Validator.isValidGeoFenceName("abcd \u05e9\u05dc\u05d5\u05dd \u05e2\u05d5\u05dc\u05dd");
        res = Validator.isValidGeoFenceName("abcd / \u05e9\u05dc\u05d5\u05dd \u05e2\u05d5\u05dc\u05dd");
        res = Validator.isValidServiceName("abcd_one");
        res = Validator.isValidServiceName("abcd[one]");
        res = Validator.isValidServiceName("abcd?one");
        res = Validator.isValidServiceName("abcd / \u05e9\u05dc\u05d5\u05dd \u05e2\u05d5\u05dc\u05dd");
        res = Validator.isValidServiceName("\u05e2\u05d5\u05dc\u05dd_\u05e2\u05d5\u05dc\u05dd");
        String out = Validator.normalizeGeoFenceName("abcd \u05e9\u05dc\u05d5\u05dd \u05e2\u05d5\u05dc\u05dd");
        out = Validator.normalizeGeoFenceName("abcd / \u05e9\u05dc\u05d5\u05dd \u05e2\u05d5\u05dc\u05dd");
        out = Validator.compactWhiteSpaces(" \t abc    def   ");
        out = Validator.compactSpaces("   \t   abc    def   ");
        out = " \t abc    def   ".trim();
        boolean endOfTest = true;
    }
}

