/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.framework.i18n.BundleResourceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class HtmlUtil {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(HtmlUtil.class);

    public static String loadCss(String fileNameWithoutSuffix) {
        File cssFile = new File("rest-support", fileNameWithoutSuffix + ".css");
        String payload = "";
        if (cssFile.exists()) {
            try {
                payload = FileUtils.readFileToString((File)cssFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                LOGGER.error("FAILED_TO_OPEN_FILE", cssFile.getAbsolutePath(), payload);
            }
        }
        return payload;
    }

    public static String htmlReplyForFile(String fileNameWithoutSuffix) {
        File errorPage = new File("rest-support", fileNameWithoutSuffix + ".html");
        String payload = null;
        if (errorPage.exists()) {
            try {
                payload = FileUtils.readFileToString((File)errorPage, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                payload = "<html><body><h1>" + fileNameWithoutSuffix + "</h1></body></html>";
                LOGGER.error("FAILED_TO_OPEN_FILE", errorPage.getAbsolutePath(), payload);
            }
        }
        payload = BundleResourceUtil.translate(payload);
        return payload;
    }
}

