/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import com.esri.core.geometry.CompositeGeographicTransformation;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorImportFromGeoJson;
import com.esri.core.geometry.OperatorImportFromJson;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.SpatialReference;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Tuple;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GeometryUtil {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(GeometryUtil.class);
    public static OperatorFactoryLocal operatorFactory = OperatorFactoryLocal.getInstance();
    private static final String WM_WKT_EXAMPLE_1 = "PROJCS[\"WGS_1984_WEB_MERCATOR_AUXILIARY_SPHERE\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"GREENWICH\",0.0],UNIT[\"DEGREE\",0.0174532925199433]],PROJECTION[\"MERCATOR_AUXILIARY_SPHERE\"],PARAMETER[\"FALSE_EASTING\",0.0],PARAMETER[\"FALSE_NORTHING\",0.0],PARAMETER[\"CENTRAL_MERIDIAN\"0.0],PARAMETER[\"STANDARD_PARALLEL_1\",0.0],PARAMETER[\"SCALE_FACTOR\",1.0],PARAMETER[\"AUXILIARY_SPHERE_TYPE\",0.0],UNIT[\"METER\",1.0]]";
    private static final String WM_WKT_EXAMPLE_2 = "PROJCS[\"WGS_1984_WEB_MERCATOR_AUXILIARY_SPHERE\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"GREENWICH\",0.0],UNIT[\"DEGREE\",0.0174532925199433]],PROJECTION[\"MERCATOR_AUXILIARY_SPHERE\"],PARAMETER[\"FALSE_EASTING\",0.0],PARAMETER[\"FALSE_NORTHING\",0.0],PARAMETER[\"CENTRAL_MERIDIAN\",-84.47937011716584],PARAMETER[\"STANDARD_PARALLEL_1\",0.0],PARAMETER[\"SCALE_FACTOR\",1.0],PARAMETER[\"AUXILIARY_SPHERE_TYPE\",0.0],UNIT[\"METER\",1.0]]";
    private static final String WM_WKT_EXAMPLE_3 = "PROJCS[\"WGS_1984_WEB_MERCATOR_AUXILIARY_SPHERE\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"GREENWICH\",0.0],UNIT[\"DEGREE\",0.0174532925199433]],PROJECTION[\"MERCATOR_AUXILIARY_SPHERE\"],PARAMETER[\"FALSE_EASTING\",0.0],PARAMETER[\"FALSE_NORTHING\",0.0],PARAMETER[\"CENTRAL_MERIDIAN\",-84.47937011716584],PARAMETER[\"STANDARD_PARALLEL_1\",0.0],PARAMETER[\"AUXILIARY_SPHERE_TYPE\",0.0],UNIT[\"METER\",1.0]]";
    private static final String WM_WKT_START = "PROJCS[\"WGS_1984_Web_Mercator_Auxiliary_Sphere\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator_Auxiliary_Sphere\"]".toUpperCase();
    private static final String WM_WKT_END = "UNIT[\"Meter\",1.0]]".toUpperCase();
    private static HashMap<String, SpatialReference> spatialReferenceCache = new HashMap();
    private static Map<String, ProjectionTransformation> fromWgs84TransformCache = new HashMap<String, ProjectionTransformation>();
    private static Map<String, ProjectionTransformation> toWgs84TransformCache = new HashMap<String, ProjectionTransformation>();
    private static Map<Tuple<String, String>, ProjectionTransformation> transformCache = new HashMap<Tuple<String, String>, ProjectionTransformation>();
    private static OperatorProject projector = OperatorProject.local();
    public static final int WGS84_WKID = 4326;
    public static final String WGS84_WKID_STRING = "4326";
    public static final int WEB_MERCATOR_WKID = 102100;
    public static final String WEB_MERCATOR_WKID_STRING = "102100";
    public static final int WEB_MERCATOR_LATEST_WKID = 3857;
    public static final String WEB_MERCATOR_LATEST_WKID_STRING = "3857";
    public static final SpatialReference WGS84_SR = SpatialReference.create(4326);
    public static final SpatialReference WEB_MERCATOR_SR = SpatialReference.create(102100);

    public static SpatialReference lookupSpatialReference(int wkid) {
        return GeometryUtil.lookupSpatialReference(wkid, false);
    }

    public static SpatialReference lookupSpatialReference(int wkid, boolean normalizeSR) {
        return GeometryUtil.lookupSpatialReference(String.valueOf(wkid), normalizeSR);
    }

    public static SpatialReference lookupSpatialReference(String srId) throws IllegalArgumentException {
        return GeometryUtil.lookupSpatialReference(srId, false);
    }

    public static SpatialReference lookupSpatialReference(String srId, boolean normalizeSR) throws IllegalArgumentException {
        SpatialReference sr;
        if (normalizeSR && (GeometryUtil.isWebMercatorWKID(srId) || GeometryUtil.isWebMercatorWKT(srId))) {
            srId = WEB_MERCATOR_WKID_STRING;
        }
        if ((sr = spatialReferenceCache.get(srId)) != null) {
            return sr;
        }
        try {
            int wkid = Integer.parseInt(srId);
            sr = SpatialReference.create(wkid);
            spatialReferenceCache.put(srId, sr);
        }
        catch (Exception ex) {
            try {
                sr = SpatialReference.create(srId);
                spatialReferenceCache.put(srId, sr);
            }
            catch (Exception exp) {
                throw new IllegalArgumentException("Could not create Spatial Reference from the string - " + srId);
            }
        }
        return sr;
    }

    public static ProjectionTransformation lookupTransformationToWgs84(String inputSrId, boolean normalizeSR) {
        ProjectionTransformation srIdToWgs84Transform = toWgs84TransformCache.get(inputSrId);
        if (srIdToWgs84Transform == null) {
            SpatialReference fromSR = GeometryUtil.lookupSpatialReference(inputSrId, normalizeSR);
            SpatialReference wgs84SR = WGS84_SR;
            srIdToWgs84Transform = ProjectionTransformation.create(fromSR, wgs84SR);
            toWgs84TransformCache.put(inputSrId, srIdToWgs84Transform);
        }
        return srIdToWgs84Transform;
    }

    public static ProjectionTransformation lookupTransformationFromWgs84(String outputSrId, boolean normalizeSR) {
        ProjectionTransformation wgs84ToSrIdTransform = fromWgs84TransformCache.get(outputSrId);
        if (wgs84ToSrIdTransform == null) {
            SpatialReference wgs84SR = WGS84_SR;
            SpatialReference toSR = GeometryUtil.lookupSpatialReference(outputSrId, normalizeSR);
            wgs84ToSrIdTransform = ProjectionTransformation.create(wgs84SR, toSR);
            fromWgs84TransformCache.put(outputSrId, wgs84ToSrIdTransform);
        }
        return wgs84ToSrIdTransform;
    }

    public static ProjectionTransformation lookupTransformation(String inputSrId, String outputSrId, boolean normalizeSR) {
        Tuple<String, String> key = new Tuple<String, String>(inputSrId, outputSrId);
        ProjectionTransformation transform = transformCache.get(key);
        if (transform == null) {
            SpatialReference fromSR = GeometryUtil.lookupSpatialReference(inputSrId, normalizeSR);
            SpatialReference toSR = GeometryUtil.lookupSpatialReference(outputSrId, normalizeSR);
            transform = ProjectionTransformation.create(fromSR, toSR);
            transformCache.put(key, transform);
        }
        return transform;
    }

    public static String getSrId(SpatialReference sr) {
        return GeometryUtil.getSrId(sr, false);
    }

    public static String getSrId(SpatialReference sr, boolean normalizeSR) {
        if (sr == null) {
            return null;
        }
        if (normalizeSR) {
            sr = GeometryUtil.normalize(sr);
        }
        String srId = sr.getID() > 0 ? Integer.toString(sr.getID()) : sr.getText();
        return srId;
    }

    public static boolean doSpatialReferencesMatch(SpatialReference sr1, SpatialReference sr2) {
        return GeometryUtil.doSpatialReferencesMatch(sr1, sr2, false);
    }

    public static boolean doSpatialReferencesMatch(SpatialReference sr1, SpatialReference sr2, boolean normalizeSR) {
        if (sr1 == null && sr2 == null) {
            return true;
        }
        if (sr1 == null || sr2 == null) {
            return false;
        }
        if (normalizeSR && GeometryUtil.isWebMercator(sr1) && GeometryUtil.isWebMercator(sr2)) {
            return true;
        }
        String srId1 = GeometryUtil.getSrId(sr1, false);
        String srId2 = GeometryUtil.getSrId(sr2, false);
        if (srId1 == null) {
            return false;
        }
        return srId1.equalsIgnoreCase(srId2);
    }

    public static SpatialReference normalize(SpatialReference sr) {
        int wkid = sr.getID();
        if (wkid == 3857) {
            return GeometryUtil.lookupSpatialReference(WEB_MERCATOR_WKID_STRING, false);
        }
        if (wkid > 0) {
            return sr;
        }
        String wkt = sr.getText();
        if (wkt == null || wkt.isEmpty()) {
            return sr;
        }
        if (GeometryUtil.isWebMercatorWKT(wkt)) {
            return GeometryUtil.lookupSpatialReference(WEB_MERCATOR_WKID_STRING, false);
        }
        return sr;
    }

    public static boolean isWebMercator(SpatialReference sr) {
        if (sr == null) {
            return false;
        }
        int wkid = sr.getID();
        if (GeometryUtil.isWebMercatorWKID(wkid)) {
            return true;
        }
        String wkt = sr.getText();
        return GeometryUtil.isWebMercatorWKT(wkt);
    }

    public static boolean isWebMercatorWKT(String wkt) {
        if (wkt == null) {
            return false;
        }
        String wktUC = wkt.toUpperCase();
        return wktUC.startsWith(WM_WKT_START) && wktUC.endsWith(WM_WKT_END);
    }

    public static boolean isWebMercatorWKID(int wkid) {
        return wkid == 102100 || wkid == 3857;
    }

    public static boolean isWebMercatorWKID(String wkid) {
        return WEB_MERCATOR_WKID_STRING.equals(wkid) || WEB_MERCATOR_LATEST_WKID_STRING.equals(wkid);
    }

    public static MapGeometry cloneMapGeometry(MapGeometry mg) {
        if (mg == null) {
            return null;
        }
        Geometry g = null;
        if (mg.getGeometry() != null) {
            g = mg.getGeometry().copy();
        }
        SpatialReference sr = null;
        if (mg.getSpatialReference() != null) {
            sr = SpatialReference.create(mg.getSpatialReference().getID());
        }
        return new MapGeometry(g, sr);
    }

    public static MapGeometry project(MapGeometry mg, SpatialReference outputSR) {
        if (mg == null) {
            return mg;
        }
        SpatialReference inputSR = mg.getSpatialReference();
        if (inputSR == null || outputSR == null) {
            return mg;
        }
        String inputSrId = GeometryUtil.getSrId(inputSR, false);
        String outputSrId = GeometryUtil.getSrId(outputSR, false);
        ProjectionTransformation transform = GeometryUtil.lookupTransformation(inputSrId, outputSrId, false);
        Geometry outputGeometry = projector.execute(mg.getGeometry(), transform, null);
        return new MapGeometry(outputGeometry, outputSR);
    }

    public static MapGeometry project(MapGeometry mg, SpatialReference outputSR, CompositeGeographicTransformation compositeGT) {
        if (mg == null) {
            return mg;
        }
        SpatialReference inputSR = mg.getSpatialReference();
        if (inputSR == null || outputSR == null) {
            return mg;
        }
        ProjectionTransformation projectionTransformation = ProjectionTransformation.createEx(inputSR, outputSR, compositeGT);
        OperatorProject projectOp = (OperatorProject)operatorFactory.getOperator(Operator.Type.Project);
        Geometry outputGeometry = projectOp.execute(mg.getGeometry(), projectionTransformation, null);
        return new MapGeometry(outputGeometry, outputSR);
    }

    public static MapGeometry fromJson(String jsonString) throws IOException {
        try {
            MapGeometry mapGeometry = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, jsonString);
            if (mapGeometry == null) {
                throw new IOException(LOGGER.translate("GEOMETRY_ENGINE_FAILED_TO_PARSE_JSON", jsonString));
            }
            return mapGeometry;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static MapGeometry fromGeoJson(String geoJsonString) throws IOException {
        try {
            MapGeometry mapGeometry = OperatorImportFromGeoJson.local().execute(16, Geometry.Type.Unknown, geoJsonString, null);
            if (mapGeometry == null) {
                throw new IOException(LOGGER.translate("GEOMETRY_ENGINE_FAILED_TO_PARSE_JSON", geoJsonString));
            }
            return mapGeometry;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String toJson(MapGeometry mapGeometry) {
        return GeometryEngine.geometryToJson(mapGeometry.getSpatialReference(), mapGeometry.getGeometry());
    }

    public static String toGeoJson(MapGeometry mapGeometry) {
        return GeometryEngine.geometryToGeoJson(mapGeometry.getSpatialReference(), mapGeometry.getGeometry());
    }

    public static String toFeatureGeoJson(MapGeometry mapGeometry) {
        String featureGeoJson = "";
        MapGeometry reprojectedGeometry = GeometryUtil.project(mapGeometry, WGS84_SR);
        if (reprojectedGeometry.getGeometry().getType() == Geometry.Type.Point) {
            Point point = (Point)reprojectedGeometry.getGeometry();
            featureGeoJson = point.hasZ() ? "[" + point.getX() + "," + point.getY() + "," + point.getZ() + "]" : "[" + point.getX() + "," + point.getY() + "]";
        } else if (reprojectedGeometry.getGeometry().getType() == Geometry.Type.Envelope) {
            Envelope envelope = (Envelope)reprojectedGeometry.getGeometry();
            featureGeoJson = "{\"type\" : \"envelope\", \"coordinates\" : [ [" + envelope.getXMin() + ", " + envelope.getYMax() + "], [" + envelope.getXMax() + ", " + envelope.getYMin() + "] ] }";
        } else {
            featureGeoJson = GeometryEngine.geometryToGeoJson(reprojectedGeometry.getGeometry());
        }
        return featureGeoJson;
    }

    public static JsonNode toJsonNode(MapGeometry mapGeometry) {
        String jsonString = GeometryUtil.toJson(mapGeometry);
        ObjectMapper geometryMapper = new ObjectMapper();
        JsonNode tree = null;
        try {
            tree = geometryMapper.readTree(jsonString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tree;
    }

    public static boolean isSameSpatialReference(SpatialReference sr1, SpatialReference sr2) {
        if (sr1 == null && sr2 == null) {
            return true;
        }
        if (sr1 == null || sr2 == null) {
            return false;
        }
        if (sr1.getID() == sr2.getID()) {
            return true;
        }
        String wkt1 = sr1.getText();
        String wkt2 = sr2.getText();
        return wkt1 != null && wkt1.equals(wkt2);
    }
}

