/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import com.esri.arcgis.discovery.admin.AdminException;
import com.esri.arcgis.discovery.admin.SiteManager;
import com.esri.arcgis.discovery.admin.machine.ServerMachineConfigurator;
import com.esri.arcgis.discovery.util.AGSIPUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GESNetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GESNetUtil.class);

    public static String getLocalServerUrl() {
        String localAdminUrl = GESNetUtil.getLocalAdminUrl();
        String strippedUrl = GESNetUtil.stripUrlEnd(localAdminUrl, "/admin");
        return strippedUrl;
    }

    public static String getLocalAdminUrl() {
        try {
            SiteManager siteManager = SiteManager.getInstance();
            String machineName = GESNetUtil.getLocalMachineName();
            return siteManager.getServerMachineManager().getServerMachine(machineName).getAdminURL();
        }
        catch (Throwable ignored) {
            String host;
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Throwable t) {
                host = "localhost";
            }
            LOGGER.debug(ignored.getMessage(), ignored);
            String defaultAdminUrl = "https://" + host + ":6443/arcgis/admin";
            return defaultAdminUrl;
        }
    }

    public static String getLocalRestUrl() {
        String localServerUrl = GESNetUtil.getLocalServerUrl();
        String localRestUrl = localServerUrl + "/rest";
        return localRestUrl;
    }

    public static String stripUrlEnd(String url, String stripChars) {
        if (url == null) {
            return url;
        }
        if (url.endsWith(stripChars)) {
            return url.substring(0, url.length() - stripChars.length());
        }
        String stripCharsEx = stripChars + "/";
        if (url.endsWith(stripCharsEx)) {
            return url.substring(0, url.length() - stripCharsEx.length());
        }
        return url;
    }

    public static boolean haveSameHost(String urlStr1, String urlStr2) {
        try {
            URL url1 = new URL(urlStr1);
            URL url2 = new URL(urlStr2);
            String host1 = url1.getHost();
            String host2 = url2.getHost();
            if (AGSIPUtil.isHostIdentical((String)host1, (String)host2)) {
                return true;
            }
            if (AGSIPUtil.areMachineNamesTheSame((String)host1, (String)host2)) {
                return true;
            }
            if (host1.equalsIgnoreCase(host2)) {
                return true;
            }
            boolean isLocalHost1 = AGSIPUtil.isValidNameForLocalHost((String)host1);
            boolean isLocalHost2 = AGSIPUtil.isValidNameForLocalHost((String)host2);
            boolean bothLocalHost = isLocalHost1 && isLocalHost2;
            return bothLocalHost;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getLocalMachineName() {
        try {
            return ServerMachineConfigurator.getServerMachineConfig().getMachineName();
        }
        catch (AdminException ignored) {
            LOGGER.debug(ignored.getMessage(), (Throwable)ignored);
            return "";
        }
    }

    public static String localhostToFQDN(String uriToNormalize) {
        String normalizedUri = uriToNormalize;
        try {
            URI uriLocalRest = new URI(normalizedUri);
            if (uriLocalRest.getHost().toLowerCase().contains("localhost")) {
                URIBuilder uriBuilder = new URIBuilder(uriLocalRest);
                uriBuilder.setHost(InetAddress.getLocalHost().getCanonicalHostName());
                normalizedUri = uriBuilder.build().toString();
            }
        }
        catch (Exception ignored) {
            LOGGER.debug(ignored.getMessage(), (Throwable)ignored);
        }
        return normalizedUri;
    }

    public static String toLocalHostCanonicalUrl(String url) {
        try {
            String canonicalUrl = url;
            URI uri = new URI(canonicalUrl);
            URIBuilder localUriBuilder = new URIBuilder(uri);
            String canonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
            localUriBuilder.setHost(canonicalHostName);
            canonicalUrl = localUriBuilder.build().toString();
            return canonicalUrl;
        }
        catch (Throwable ignored) {
            LOGGER.debug(ignored.getMessage(), ignored);
            return url;
        }
    }
}

