/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.util;

import com.esri.core.geometry.MapGeometry;
import com.esri.ges.util.DateUtil;
import com.esri.ges.util.GeometryUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public abstract class Converter {
    static final String HEXES = "0123456789ABCDEF";

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String convertToString(Object value) {
        return value != null ? (value instanceof String ? (String)value : value.toString()) : null;
    }

    public static String convertToGeometryJson(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof MapGeometry) {
            return GeometryUtil.toJson((MapGeometry)value);
        }
        return null;
    }

    public static MapGeometry convertToGeometry(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof MapGeometry) {
            return (MapGeometry)value;
        }
        if (value instanceof String) {
            try {
                return GeometryUtil.fromJson((String)value);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static Date convertToDate(Object value) {
        if (value != null) {
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Long) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis((Long)value);
                return calendar.getTime();
            }
            if (value instanceof String) {
                try {
                    return DateUtil.checkedConvert((String)value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Boolean convertToBoolean(String s, Boolean defaultValue) {
        if (!Converter.isEmpty(s)) {
            String v = s.toLowerCase().trim();
            if (v.equals("true")) {
                return true;
            }
            if (v.equals("false")) {
                return false;
            }
            if (v.equals("y")) {
                return true;
            }
            if (v.equals("n")) {
                return false;
            }
            if (v.equals("yes")) {
                return true;
            }
            if (v.equals("no")) {
                return false;
            }
            if (v.equals("on")) {
                return true;
            }
            if (v.equals("off")) {
                return false;
            }
            if (v.equals("0")) {
                return false;
            }
            if (v.equals("1")) {
                return true;
            }
            if (v.equals("-1")) {
                return false;
            }
        }
        return defaultValue;
    }

    public static Boolean convertToBoolean(Object value) {
        return value != null ? (value instanceof Boolean ? (Boolean)value : Converter.convertToBoolean(value.toString(), null)) : null;
    }

    public static Float convertToFloat(String s, Float defaultValue) {
        if (!Converter.isEmpty(s)) {
            try {
                return Float.valueOf(Float.parseFloat(s.replaceAll(",", ".")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Float convertToFloat(Object value) {
        return value != null ? (value instanceof Float ? (Float)value : Converter.convertToFloat(value.toString(), null)) : null;
    }

    public static Double convertToDouble(String s, Double defaultValue) {
        if (!Converter.isEmpty(s)) {
            try {
                return Double.parseDouble(s.replaceAll(",", "."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Double convertToDouble(Object value) {
        return value != null ? (value instanceof Double ? (Double)value : Converter.convertToDouble(value.toString(), null)) : null;
    }

    public static Integer convertToInteger(String s, Integer defaultValue) {
        if (!Converter.isEmpty(s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Integer convertToInteger(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            Double doubleValue = Converter.convertToDouble(value);
            if (doubleValue != null) {
                return Long.valueOf(Math.round(doubleValue)).intValue();
            }
        }
        return null;
    }

    public static Short convertToShort(String s, Short defaultValue) {
        if (!Converter.isEmpty(s)) {
            try {
                return Short.parseShort(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Short convertToShort(Object value) {
        if (value != null) {
            if (value instanceof Short) {
                return (Short)value;
            }
            Double doubleValue = Converter.convertToDouble(value);
            if (doubleValue != null) {
                return Long.valueOf(Math.round(doubleValue)).shortValue();
            }
        }
        return null;
    }

    public static Long convertToLong(String s, Long defaultValue) {
        if (!Converter.isEmpty(s)) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Long convertToLong(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            Double doubleValue = Converter.convertToDouble(value);
            if (doubleValue != null) {
                return Math.round(doubleValue);
            }
        }
        return null;
    }

    public static UUID convert(String s) {
        UUID value = null;
        try {
            value = UUID.fromString(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return value;
    }

    public static String escapeQuotes(String s) {
        if (Converter.isEmpty(s)) {
            return "";
        }
        int nIdx1 = s.indexOf("\"");
        int nIdx2 = s.indexOf("'");
        if (nIdx1 != -1 || nIdx2 != -1) {
            StringBuffer sb = new StringBuffer(s.length() + 20);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\'' || c == '\"') {
                    sb.append("\\");
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return s;
    }

    public static String escapeXmlForBrowser(String s) {
        if (Converter.isEmpty(s)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(s.length() + 20);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String convert(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(3 * bytes.length);
        for (byte b : bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF)).append(" ");
        }
        return hex.toString().trim();
    }
}

