/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.transport;

import com.esri.ges.core.component.ClusterCommand;
import com.esri.ges.core.component.ComponentBase;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.component.RunningException;
import com.esri.ges.core.component.RunningState;
import com.esri.ges.core.component.RunningStateListener;
import com.esri.ges.transport.Transport;
import com.esri.ges.transport.TransportContext;
import com.esri.ges.transport.TransportDefinition;
import com.esri.ges.transport.TransportType;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public abstract class TransportBase
extends ComponentBase
implements Transport {
    private RunningState runningState = RunningState.STOPPED;
    private ClusterCommand clusterCommand = ClusterCommand.STOP;
    private String stateSemaphore = "stateSemaphore";
    private RunningStateListener runningStateListener = null;
    private String errorMessage;

    public TransportBase(TransportDefinition definition) throws ComponentException {
        super(definition);
    }

    @Override
    public TransportType getType() {
        return this.getDefinition().getTransportType();
    }

    @Override
    public TransportDefinition getDefinition() {
        return (TransportDefinition)this.definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningState getRunningState() {
        String string = this.stateSemaphore;
        synchronized (string) {
            return this.runningState;
        }
    }

    @Override
    public void setClusterCommand(ClusterCommand command) {
        this.clusterCommand = command;
    }

    @Override
    public ClusterCommand getClusterCommand() {
        return this.clusterCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRunningState(RunningState newState) {
        String string = this.stateSemaphore;
        synchronized (string) {
            this.runningState = newState;
        }
        if (this.runningStateListener != null) {
            this.runningStateListener.onStateChange(newState);
        }
    }

    @Override
    public void setRunningStateListener(RunningStateListener listener) {
        this.runningStateListener = listener;
    }

    @Override
    public boolean isRunning() {
        return RunningState.STARTED.equals((Object)this.getRunningState());
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getStatusDetails() {
        return this.errorMessage;
    }

    @Override
    public void afterPropertiesSet() {
        block5: {
            try {
                if (!this.isRunning()) break block5;
                this.stop();
                long waitingStartTime = System.currentTimeMillis();
                long timeLimit = 10000L;
                long elapsedTime = System.currentTimeMillis() - waitingStartTime;
                while (this.getRunningState() == RunningState.STOPPING && elapsedTime < timeLimit) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    elapsedTime = System.currentTimeMillis() - waitingStartTime;
                }
                this.start();
            }
            catch (RunningException runningException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.setErrorMessage(null);
        if (this.isRunning()) {
            this.setRunningState(RunningState.STOPPING);
        }
    }

    @Override
    public void beforeConnect(TransportContext context) {
    }

    @Override
    public void onConnect(TransportContext context) {
    }

    @Override
    public void onReceive(TransportContext context) {
    }

    @Override
    public void onError(TransportContext context) {
    }

    protected CharsetDecoder getCharsetDecoder() {
        Charset charset = StandardCharsets.UTF_8;
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        return decoder;
    }
}

