/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import com.esri.core.geometry.SpatialReference;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.util.GeometryUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PublishStreamServiceRequest {
    private boolean overrideExisting = false;
    private String clusterName;
    private String path;
    private String serviceName;
    private String layerName = "layer";
    private String relatedFeaturesUrl = "";
    private String relatedFeatureJoinField = "";
    private String displayFieldName;
    private SpatialReference sr = GeometryUtil.WGS84_SR;
    private String geometryType;
    private String layerDrawingInfo;
    private GeoEventDefinition def;
    private boolean keepLatest = false;
    private String keepLatestFeatureServiceUrl;
    private String keepLatestDatastoreUrl;
    private String keepLatestDataSourceName;
    private String keepLatestDataSourceLayerName;
    private int keepLatestFlushInterval = 50;
    private int keepLatestMaxTransactionSize = 1000;
    private int updateInterval = 5;
    private int maximumFeatureAge = 60;

    public PublishStreamServiceRequest() {
    }

    public PublishStreamServiceRequest(boolean overrideExisting, GeoEventDefinition def, String clusterName, String path, String serviceName, String layerName, String relatedFeaturesUrl, String relatedFeatureJoinField, String srid, String geometryType, String displayFieldName, String layerDrawingInfo, boolean keepLatest, String keepLatestFeatureServiceUrl, String keepLatestDatastoreUrl, String keepLatestDataSourceName, String keepLatestDataSourceLayerName, int keepLatestFlushInterval, int keepLatestMaxTransactionSize, int updateInterval, int maximumFeatureAge) {
        this.overrideExisting = overrideExisting;
        this.def = def;
        this.clusterName = clusterName;
        this.path = path;
        this.serviceName = serviceName;
        this.layerName = layerName;
        this.relatedFeaturesUrl = relatedFeaturesUrl;
        this.relatedFeatureJoinField = relatedFeatureJoinField;
        this.sr = GeometryUtil.lookupSpatialReference(srid);
        this.geometryType = geometryType;
        this.displayFieldName = displayFieldName;
        this.layerDrawingInfo = layerDrawingInfo;
        this.keepLatest = keepLatest;
        this.keepLatestFeatureServiceUrl = keepLatestFeatureServiceUrl;
        this.keepLatestDatastoreUrl = keepLatestDatastoreUrl;
        this.keepLatestDataSourceName = keepLatestDataSourceName;
        this.keepLatestDataSourceLayerName = keepLatestDataSourceLayerName;
        this.keepLatestFlushInterval = keepLatestFlushInterval;
        this.keepLatestMaxTransactionSize = keepLatestMaxTransactionSize;
        this.updateInterval = updateInterval;
        this.maximumFeatureAge = maximumFeatureAge;
    }

    public boolean isOverrideExisting() {
        return this.overrideExisting;
    }

    public void setOverrideExisting(boolean overrideExisting) {
        this.overrideExisting = overrideExisting;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public SpatialReference getSR() {
        return this.sr;
    }

    public void setSR(SpatialReference sr) {
        this.sr = sr;
    }

    public void setSR(String srid) {
        this.sr = GeometryUtil.lookupSpatialReference(srid);
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(String geometryType) {
        this.geometryType = geometryType;
    }

    public String getDisplayFieldName() {
        return this.displayFieldName;
    }

    public void setDisplayFieldName(String displayFieldName) {
        this.displayFieldName = displayFieldName;
    }

    public String getLayerDrawingInfo() {
        return this.layerDrawingInfo;
    }

    public void setLayerDrawingInfo(String layerDrawingInfo) {
        this.layerDrawingInfo = layerDrawingInfo;
    }

    public GeoEventDefinition getDef() {
        return this.def;
    }

    public void setDef(GeoEventDefinition def) {
        this.def = def;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getRelatedFeaturesUrl() {
        return this.relatedFeaturesUrl;
    }

    public void setRelatedFeaturesUrl(String relatedFeaturesUrl) {
        this.relatedFeaturesUrl = relatedFeaturesUrl;
    }

    public String getRelatedFeatureJoinField() {
        return this.relatedFeatureJoinField;
    }

    public void setRelatedFeatureJoinField(String relatedFeatureJoinField) {
        this.relatedFeatureJoinField = relatedFeatureJoinField;
    }

    public boolean isKeepLatest() {
        return this.keepLatest;
    }

    public void setKeepLatest(boolean keepLatest) {
        this.keepLatest = keepLatest;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public int getMaximumFeatureAge() {
        return this.maximumFeatureAge;
    }

    public void setMaximumFeatureAge(int maximumFeatureAge) {
        this.maximumFeatureAge = maximumFeatureAge;
    }

    public String getKeepLatestFeatureServiceUrl() {
        return this.keepLatestFeatureServiceUrl;
    }

    public void setKeepLatestFeatureServiceUrl(String keepLatestFeatureServiceUrl) {
        this.keepLatestFeatureServiceUrl = keepLatestFeatureServiceUrl;
    }

    public String getKeepLatestDatastoreUrl() {
        return this.keepLatestDatastoreUrl;
    }

    public void setKeepLatestDatastoreUrl(String keepLatestDatastoreUrl) {
        this.keepLatestDatastoreUrl = keepLatestDatastoreUrl;
    }

    public String getKeepLatestDataSourceName() {
        return this.keepLatestDataSourceName;
    }

    public void setKeepLatestDataSourceName(String keepLatestDataSourceName) {
        this.keepLatestDataSourceName = keepLatestDataSourceName;
    }

    public String getKeepLatestDataSourceLayerName() {
        return this.keepLatestDataSourceLayerName;
    }

    public void setKeepLatestDataSourceLayerName(String keepLatestDataSourceLayerName) {
        this.keepLatestDataSourceLayerName = keepLatestDataSourceLayerName;
    }

    public int getKeepLatestFlushInterval() {
        return this.keepLatestFlushInterval;
    }

    public void setKeepLatestFlushInterval(int keepLatestFlushInterval) {
        this.keepLatestFlushInterval = keepLatestFlushInterval;
    }

    public int getKeepLatestMaxTransactionSize() {
        return this.keepLatestMaxTransactionSize;
    }

    public void setKeepLatestMaxTransactionSize(int keepLatestMaxTransactionSize) {
        this.keepLatestMaxTransactionSize = keepLatestMaxTransactionSize;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

