/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import com.esri.ges.manager.datastore.agsconnection.Datasource;
import com.esri.ges.util.Validator;

public class Layer {
    private int id = 0;
    private String name = "";
    private String url = "";
    private boolean hasGeometry;
    private Datasource dataSource = null;

    public Layer(int id, String name, String url, boolean hasGeometry, Datasource dataSource) {
        this.id = id;
        this.name = Validator.compactSpaces(name);
        this.url = url;
        this.hasGeometry = hasGeometry;
        this.dataSource = dataSource;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isHasGeometry() {
        return this.hasGeometry;
    }

    public boolean isHasBDSDatasource() {
        return this.dataSource != null && this.dataSource.isBDSDatasource();
    }

    public Datasource getDatasource() {
        return this.dataSource;
    }

    public void setDatasource(Datasource dataSource) {
        this.dataSource = dataSource;
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }
}

