/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.datastore.agsconnection;

import com.esri.ges.manager.datastore.agsconnection.FieldDomain;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;

public class Field {
    private String name;
    private String type;
    private String alias;
    private FieldDomain domain;

    public Field(String name, String type, String alias, FieldDomain domain) {
        this.name = name;
        this.type = type;
        this.alias = alias;
        this.domain = domain;
    }

    public Field(JsonNode jsonField) {
        JsonNode domainNode;
        if (jsonField.has("name")) {
            this.name = jsonField.get("name").textValue();
        }
        if (jsonField.has("type")) {
            this.type = jsonField.get("type").textValue();
        }
        if (jsonField.has("alias")) {
            this.alias = jsonField.get("alias").textValue();
        }
        if (jsonField.has("domain") && (domainNode = jsonField.get("domain")) != null && domainNode.has("type")) {
            String domainType = "";
            if (domainNode.has("type")) {
                domainType = domainNode.get("type").asText();
            }
            String domainName = "";
            if (domainNode.has("name")) {
                domainName = domainNode.get("name").asText();
            }
            if (domainType.equals("codedValue") && domainNode.has("codedValues")) {
                HashMap<String, String> codedValues = new HashMap<String, String>();
                for (JsonNode codedValue : domainNode.get("codedValues")) {
                    if (!codedValue.has("code") || !codedValue.has("name")) continue;
                    String code = codedValue.get("code").asText();
                    String val = codedValue.get("name").asText();
                    codedValues.put(code, val);
                }
                this.domain = new FieldDomain(domainType, domainName, codedValues);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ");
        sb.append(this.name);
        sb.append("/alias: ");
        sb.append(this.alias);
        sb.append("/type: ");
        sb.append(this.type);
        return sb.toString();
    }

    public FieldDomain getDomain() {
        return this.domain;
    }

    public void setDomain(FieldDomain domain) {
        this.domain = domain;
    }
}

