/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.manager.aoi;

import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class GeofenceSynchronization {
    private String id;
    private String label;
    private String dataStoreName;
    private String path;
    private String serviceName;
    private String layer;
    private long refreshInterval;
    private String nameField;
    private String categoryField;
    private String activeField;
    private long lastUpdate = 0L;
    private boolean lastResult = true;
    private long maxAllowableOffset = -1L;
    private int wkid;
    private String serverType;
    private String timeField;
    private Long lastUpdateTimeValue = null;
    private Long lastUpdateValue = null;
    private String fieldType = null;
    private String startTimeField;
    private String endTimeField;
    private boolean incrementalUpdate;
    private String optionalQuery;
    private Map<String, Map<String, Long>> synced;

    public GeofenceSynchronization(String id, String label, String dataStoreName, String path, String serviceName, String layer, long refreshInterval, String nameField, String categoryField, String activeField, long maxAllowableOffset, int wkid, String serverType, String timeField, String startTimeField, String endTimeField, boolean incrementalUpdate) {
        this.id = id;
        this.label = label;
        this.dataStoreName = dataStoreName;
        this.path = path;
        this.serviceName = serviceName;
        this.layer = layer;
        this.refreshInterval = refreshInterval;
        this.nameField = nameField;
        this.categoryField = categoryField;
        this.activeField = activeField;
        this.maxAllowableOffset = maxAllowableOffset;
        this.wkid = wkid;
        this.serverType = serverType;
        this.timeField = timeField;
        this.startTimeField = startTimeField;
        this.endTimeField = endTimeField;
        this.incrementalUpdate = incrementalUpdate;
    }

    public String getDataStoreName() {
        return this.dataStoreName;
    }

    public void setDataStoreName(String dataStoreName) {
        this.dataStoreName = dataStoreName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public String getCategoryField() {
        return this.categoryField;
    }

    public void setCategoryField(String categoryField) {
        this.categoryField = categoryField;
    }

    public String getActiveField() {
        return this.activeField;
    }

    public void setActiveField(String activeField) {
        this.activeField = activeField;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean timeToUpdate() {
        long secondsSinceLastUpdate = (System.currentTimeMillis() - this.lastUpdate) / 1000L;
        return secondsSinceLastUpdate > this.refreshInterval;
    }

    public void update() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public boolean getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(boolean lastResult) {
        this.lastResult = lastResult;
    }

    public long getMaxAllowableOffset() {
        return this.maxAllowableOffset;
    }

    public void setMaxAllowableOffset(long maxAllowableOffset) {
        this.maxAllowableOffset = maxAllowableOffset;
    }

    public int getWkid() {
        return this.wkid;
    }

    public void setWkid(int wkid) {
        this.wkid = wkid;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public void setTimeField(String timeField) {
        this.timeField = timeField;
        this.lastUpdateTimeValue = null;
        this.fieldType = null;
    }

    public Long getLastUpdateTimeValue() {
        return this.lastUpdateTimeValue;
    }

    public void setLastUpdateTimeValue(Long lastUpdateTimeValue) {
        this.lastUpdateTimeValue = lastUpdateTimeValue;
    }

    public Long getLastUpdateValue() {
        return this.lastUpdateValue;
    }

    public void setLastUpdateValue(Long lastUpdateValue) {
        this.lastUpdateValue = lastUpdateValue;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getStartTimeField() {
        return this.startTimeField;
    }

    public void setStartTimeField(String startTimeField) {
        this.startTimeField = startTimeField;
    }

    public String getEndTimeField() {
        return this.endTimeField;
    }

    public void setEndTimeField(String endTimeField) {
        this.endTimeField = endTimeField;
    }

    public boolean isIncrementalUpdate() {
        return this.incrementalUpdate;
    }

    public void setIncrementalUpdate(boolean incrementalUpdate) {
        this.incrementalUpdate = incrementalUpdate;
    }

    public String getOptionalQuery() {
        return this.optionalQuery;
    }

    public void setOptionalQuery(String optionalQuery) {
        this.optionalQuery = optionalQuery;
    }

    public Map<String, Map<String, Long>> getSynced() {
        return this.synced;
    }

    public void setSynced(Map<String, Map<String, Long>> synced) {
        this.synced = synced;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

