/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.property;

import com.esri.ges.core.property.PropertyType;
import com.esri.ges.util.Validator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.builder.EqualsBuilder;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_DESC}")
@XmlRootElement(name="property")
@XmlType(propOrder={"name", "value"})
public class PropertyWrapper {
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_VALUE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_VALUE_SAMPLE}")
    private String value;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROP_MODEL_TYPE_SAMPLE}")
    private PropertyType type;
    private static final List<PropertyType> sensitiveTypes = Arrays.asList(PropertyType.Password);

    public PropertyWrapper() {
    }

    public PropertyWrapper(String name, String value, PropertyType propertyType, boolean hideSensitiveTypes) {
        this.setName(name);
        if (hideSensitiveTypes && sensitiveTypes.contains((Object)propertyType)) {
            this.setValue("");
        } else {
            this.setValue(value);
        }
        this.type = propertyType;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Validator.compactSpaces(name);
    }

    @XmlValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = Validator.compactSpaces(value);
    }

    @XmlAttribute
    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ [name=");
        sb.append(this.name);
        sb.append("][value=");
        sb.append(this.value);
        sb.append("] }");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PropertyWrapper)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PropertyWrapper otherWrapper = (PropertyWrapper)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.name, (Object)otherWrapper.name);
        equalsBuilder.append((Object)this.value, (Object)otherWrapper.value);
        equalsBuilder.append((Object)this.type, (Object)otherWrapper.type);
        return equalsBuilder.isEquals();
    }
}

