/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.property;

import com.esri.ges.core.property.LabeledValue;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.jaxb.common.LabeledValueWrapper;
import com.esri.ges.util.Validator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DESC}")
@XmlRootElement(name="PropertyDefinition")
@XmlType(propOrder={"propertyName", "label", "description", "propertyType", "defaultValue", "mandatory", "readOnly", "displayOption", "dependsOn", "allowedValues"})
public class PropertyDefinitionWrapper {
    private static final String ALLOWEDVALS_PROP_NAME = "allowedValues";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_NAME_SAMPLE}")
    private String propertyName;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_TYPE_SAMPLE}", allowableValues="String,Date,Boolean,Geometry,Short,Integer,Long,Float,Double,Password,FolderDataStore,Condition,GeoEventDefinition,GeoEventDefinitionField,GeoEventField_Geometry,KeyValueMap,SelectableFinalMap,StringList,ArcGISConnection,ArcGISFolder, ArcGISFeatureService,ArcGISServiceType,ArcGISLayer,ArcGISLayerFieldNames,ArcGISField, ArcGISDateTimeField,ArcGISStreamService,ArcGISStreamLayer, ArcGISBDSConnection,ArcGISBDSSource,ArcGISBDSSourceLayer,TaskSchedule")
    private String propertyType;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_MANDATORY_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_MANDATORY_SAMPLE}")
    private boolean mandatory;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_READ_ONLY_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_READ_ONLY_SAMPLE}")
    private boolean readOnly;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_LABEL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_LABEL_SAMPLE}")
    private String label;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DESCRIPTION_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DESCRIPTION_SAMPLE}")
    private String description;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DEFAULT_VALUE_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DEFAULT_VALUE_SAMPLE}")
    private String defaultValue;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_ALLOWABLE_VALUES_LBL}", required=false)
    private List<LabeledValueWrapper> allowedValues;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DEPENDS_ON_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DEPENDS_ON_SAMPLE}")
    private String dependsOn;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DISPLAY_OPTION_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.PROPERTY_MODEL_DISPLAY_OPTION_SAMPLE}")
    private String displayOption;

    public PropertyDefinitionWrapper() {
    }

    public PropertyDefinitionWrapper(PropertyDefinition seed) {
        this.propertyName = seed.getPropertyName();
        this.label = seed.getLabel();
        this.propertyType = seed.getType().toString();
        this.mandatory = seed.isMandatory();
        this.readOnly = seed.isReadOnly();
        this.description = seed.getDescription();
        this.defaultValue = seed.getDefaultValue() != null ? seed.getDefaultValue().toString() : null;
        ArrayList<LabeledValueWrapper> allowedValues = new ArrayList<LabeledValueWrapper>();
        if (seed.getAllowedValues() != null && seed.getAllowedValues().size() > 0) {
            for (LabeledValue allowedValueSeed : seed.getAllowedValues()) {
                allowedValues.add(new LabeledValueWrapper(allowedValueSeed));
            }
        }
        if (!allowedValues.isEmpty()) {
            this.setAllowedValues(allowedValues);
        }
        this.dependsOn = seed.getDependsOn();
        this.displayOption = seed.getDisplayOption();
    }

    @XmlAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String displayName) {
        this.label = displayName;
    }

    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute
    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    @XmlAttribute
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @XmlAttribute
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @XmlAttribute
    @JsonProperty(value="defaultValue")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (!Validator.isEmpty(defaultValue)) {
            this.defaultValue = defaultValue;
        }
    }

    @XmlElementWrapper(name="allowedValues")
    @XmlElement(name="value")
    @JsonProperty(value="allowedValues")
    public List<LabeledValueWrapper> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<LabeledValueWrapper> values) {
        this.allowedValues = values;
    }

    @XmlAttribute
    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    @XmlAttribute
    public String getDisplayOption() {
        return this.displayOption;
    }

    public void setDisplayOption(String displayOption) {
        this.displayOption = displayOption;
    }
}

