/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.globalproperty;

import com.esri.ges.core.property.GlobalProperty;
import com.esri.ges.core.property.LabeledValue;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.core.property.PropertyUtil;
import com.esri.ges.core.security.GeoEventServerCryptoService;
import com.esri.ges.jaxb.common.LabeledValueWrapper;
import com.esri.ges.util.Validator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.GP_MODEL_DESC}")
@XmlRootElement(name="globalProperty")
@XmlType(propOrder={"ownerName", "ownerLabel", "name", "label", "description", "type", "defaultValue", "value", "id", "allowedValues"})
public class GlobalPropertyWrapper
implements GlobalProperty {
    private static final String VALUE_PROP_NAME = "value";
    private static final String DEFVALUE_PROP_NAME = "defaultValue";
    private static final String ALLOWDVALS_PROP_NAME = "allowedValues";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_OWNER_NAME_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_OWNER_NAME_SAMPLE}")
    private String ownerName;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_OWNER_LABEL_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_OWNER_LABEL_SAMPLE}")
    private String ownerLabel;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_NAME_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_LABEL_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_LABEL_SAMPLE}")
    private String label;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_DESCRIPTION_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_DESCRIPTION_SAMPLE}")
    private String description;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_TYPE_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_TYPE_SAMPLE}")
    private PropertyType type;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_DEFAULT_VALUE_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_DEFAULT_VALUE_SAMPLE}")
    private Object defaultValue;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_VALUE_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_VALUE_SAMPLE}")
    private Object value;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_ID_LBL}", required=false, example="${com.esri.ges.rest.cxf-swagger.GP_MODEL_ID_SAMPLE}")
    private String id;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.GP_MODEL_ALLOWED_VALUES_LBL}", required=false)
    private List<LabeledValueWrapper> allowedValues;

    public GlobalPropertyWrapper() {
    }

    public GlobalPropertyWrapper(String ownerName, String ownerLabel, String name, String label, String description, PropertyType type, String defaultValue, String value, String id, List<LabeledValueWrapper> allowedValues) {
        this.ownerName = ownerName;
        this.ownerLabel = ownerLabel;
        this.name = name;
        this.label = label;
        this.description = description;
        this.type = type;
        this.defaultValue = defaultValue;
        this.value = value;
        this.id = id;
        this.allowedValues = allowedValues;
    }

    public GlobalPropertyWrapper(GlobalProperty prop) {
        if (prop != null) {
            this.setOwnerName(prop.getOwnerName());
            this.setOwnerLabel(prop.getOwnerLabel());
            this.setName(prop.getName());
            this.setLabel(prop.getLabel());
            this.setDescription(prop.getDescription());
            this.setType(prop.getType());
            this.setDefaultValue(PropertyUtil.valueToString(prop.getDefaultValue(), prop.getType()));
            this.setValue(PropertyUtil.valueToString(prop.getValue(), prop.getType()));
            this.setId(prop.getId());
            this.setAllowedValues(prop.getAllowedValues());
        }
    }

    @Override
    @XmlAttribute
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    @XmlAttribute
    public String getOwnerLabel() {
        return this.ownerLabel;
    }

    public void setOwnerLabel(String ownerLabel) {
        this.ownerLabel = ownerLabel;
    }

    @Override
    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @XmlAttribute
    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    @Override
    @XmlElement(name="defaultValue")
    @JsonProperty(value="defaultValue")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    @XmlElement(name="value")
    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    @XmlElementWrapper(name="allowedValues", required=false)
    @XmlElement(name="allowedValue", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="allowedValues")
    public List<LabeledValue> getAllowedValues() {
        return this.toAllowedValues(this.allowedValues);
    }

    @Override
    public void setAllowedValues(List<LabeledValue> values) {
        this.allowedValues = this.toAllowedValuesWrapper(values);
    }

    @Override
    public void reset() {
        this.setValue(this.getDefaultValue());
    }

    public boolean encrypt(GeoEventServerCryptoService cryptoService, boolean defaultValueAsWell) throws Exception {
        boolean encrypted = false;
        if (cryptoService != null && this.getType() == PropertyType.Password) {
            if (this.isNotEmptyString(this.getValue())) {
                this.setValue(cryptoService.encrypt(this.getValue().toString()));
                encrypted = true;
            }
            if (defaultValueAsWell && this.isNotEmptyString(this.getDefaultValue())) {
                this.setDefaultValue(cryptoService.encrypt(this.getDefaultValue().toString()));
                encrypted = true;
            }
        }
        return encrypted;
    }

    public boolean decrypt(GeoEventServerCryptoService cryptoService, String cryptoKey, boolean defaultValueAsWell) throws Exception {
        boolean decrypted = false;
        if (cryptoService != null && this.getType() == PropertyType.Password) {
            if (this.isNotEmptyString(this.getValue())) {
                if (cryptoKey != null) {
                    this.setValue(cryptoService.decrypt(cryptoKey, this.getValue().toString()));
                } else {
                    this.setValue(cryptoService.decrypt(this.getValue().toString()));
                }
                decrypted = true;
            }
            if (defaultValueAsWell && this.isNotEmptyString(this.getDefaultValue())) {
                if (cryptoKey != null) {
                    this.setDefaultValue(cryptoService.decrypt(cryptoKey, this.getDefaultValue().toString()));
                } else {
                    this.setDefaultValue(cryptoService.decrypt(this.getDefaultValue().toString()));
                }
                decrypted = true;
            }
        }
        return decrypted;
    }

    private boolean isNotEmptyString(Object value) {
        try {
            String str = (String)value;
            return Validator.isNotEmpty(str);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private List<LabeledValueWrapper> toAllowedValuesWrapper(List<LabeledValue> values) {
        if (values == null) {
            return null;
        }
        ArrayList<LabeledValueWrapper> allowedValuesWrapper = new ArrayList<LabeledValueWrapper>();
        for (LabeledValue value : values) {
            LabeledValueWrapper wrapper = new LabeledValueWrapper(value);
            allowedValuesWrapper.add(wrapper);
        }
        return allowedValuesWrapper;
    }

    public List<LabeledValue> toAllowedValues(List<LabeledValueWrapper> allowedValuesWrapper) {
        if (allowedValuesWrapper == null) {
            return null;
        }
        ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
        for (LabeledValueWrapper wrapper : allowedValuesWrapper) {
            if (wrapper == null) continue;
            LabeledValue value = wrapper.toLabeledValue();
            values.add(value);
        }
        return values;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

