/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.datastore;

import com.esri.ges.core.AccessType;
import com.esri.ges.datastore.folder.FolderDataStore;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.DS_FOLDER_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.DS_FOLDER_MODEL_DESC}")
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="folderDataStore")
public class FolderDataStoreWrapper {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(FolderDataStoreWrapper.class);
    private static final String DETAILS_PROP_NAME = "details";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_LABEL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_LABEL_SAMPLE}")
    private String label;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_PATH_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_PATH_SAMPLE}")
    private String path;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_DETAILS_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_DETAILS_SAMPLE}")
    private String details;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_EXISTS_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_EXISTS_SAMPLE}")
    private boolean exists;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_CAN_READ_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_CAN_READ_SAMPLE}")
    private boolean canRead;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_CAN_WRITE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_CAN_WRITE_SAMPLE}")
    private boolean canWrite;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_ACCESS_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.DS_MODEL_FOLDERS_ACCESS_TYPE_SAMPLE}", allowableValues="editable,nonDeletable,readOnly")
    private AccessType accessType = AccessType.editable;

    public FolderDataStoreWrapper() {
    }

    public FolderDataStoreWrapper(FolderDataStore seed) {
        this.setName(seed.getName());
        this.setLabel(seed.getLabel());
        this.setPath(seed.getPath().getAbsolutePath());
        this.setDetails(seed.getStatus());
        this.setExists(seed.isExists());
        this.setCanRead(seed.isCanRead());
        this.setCanWrite(seed.isCanWrite());
        this.setAccessType(seed.getAccessType().toString());
        this.normalize();
    }

    protected void normalize() {
        this.normalizeLabel();
    }

    protected void normalizeLabel() {
        this.label = Validator.normalizeLabel(this.label, this.name);
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.normalizeLabel();
    }

    @XmlAttribute(required=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlAttribute
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @XmlElement(name="details")
    @JsonProperty(value="details")
    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @XmlAttribute
    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    @XmlAttribute
    public boolean isCanRead() {
        return this.canRead;
    }

    public void setCanRead(boolean canRead) {
        this.canRead = canRead;
    }

    @XmlAttribute
    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    @XmlAttribute
    public String getAccessType() {
        return this.accessType.toString();
    }

    public void setAccessType(String accessTypeStr) {
        AccessType accessType = AccessType.getAccessType(accessTypeStr);
        if (accessType == AccessType.unknown) {
            LOGGER.warn("INVALID_ACCESS_TYPE", new Object[]{accessTypeStr, AccessType.editable});
            this.accessType = AccessType.editable;
        } else {
            this.accessType = accessType;
        }
    }
}

