/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.datastore;

import com.esri.arcgis.bds.EsriGeoHash;
import com.esri.arcgis.bds.GeoHashStyle;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="EsriGeoHash")
public class EsriGeoHashWrapper {
    private GeoHashStyle style;
    private String sr;
    private int lods;

    public EsriGeoHashWrapper() {
        this.style = GeoHashStyle.square;
        this.sr = "102100";
        this.lods = 20;
    }

    public EsriGeoHashWrapper(GeoHashStyle geoHashStyle, String sr, int lods) {
        this.style = geoHashStyle;
        this.sr = sr;
        this.lods = lods;
    }

    @XmlAttribute
    public GeoHashStyle getStyle() {
        return this.style;
    }

    public void setStyle(GeoHashStyle style) {
        this.style = style;
    }

    @XmlAttribute
    public String getSr() {
        return this.sr;
    }

    public void setSr(String sr) {
        this.sr = sr;
    }

    @XmlAttribute
    public int getLods() {
        return this.lods;
    }

    public void setLods(int lods) {
        this.lods = lods;
    }

    public static EsriGeoHash[] toEsriGeoHashArray(List<EsriGeoHashWrapper> wrappers) {
        if (wrappers == null) {
            return null;
        }
        ArrayList<EsriGeoHash> esriGeoHashes = new ArrayList<EsriGeoHash>();
        for (EsriGeoHashWrapper wrapper : wrappers) {
            EsriGeoHash esriGeoHash = new EsriGeoHash(wrapper.getStyle(), wrapper.getSr(), wrapper.getLods());
            esriGeoHashes.add(esriGeoHash);
        }
        return esriGeoHashes.toArray(new EsriGeoHash[esriGeoHashes.size()]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EsriGeoHashWrapper)) {
            return false;
        }
        EsriGeoHashWrapper that = (EsriGeoHashWrapper)obj;
        if (this.getStyle() != that.getStyle()) {
            return false;
        }
        if (this.getLods() != that.getLods()) {
            return false;
        }
        return this.getSr().equals(that.getSr());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

