/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.datastore;

import com.esri.ges.jaxb.datastore.ArcGISServerServiceWrapper;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerConnection;
import com.esri.ges.manager.datastore.agsconnection.ArcGISServerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="arcgisServerFolder")
public class ArcGISServerFolderWrapper {
    private static final String STREAMSVCS_PROP_NAME = "streamservices";
    private static final String SVCS_PROP_NAME = "services";
    private static final String NAME_PROP_NAME = "name";
    private static final String MAPSVCS_PROP_NAME = "mapservices";
    private static final String LABEL_PROP_NAME = "label";
    private String name;
    private String label;
    private List<ArcGISServerServiceWrapper> services;
    private List<ArcGISServerServiceWrapper> streamservices;
    private List<ArcGISServerServiceWrapper> mapservices;

    public ArcGISServerFolderWrapper() {
        this.name = null;
        this.services = new ArrayList<ArcGISServerServiceWrapper>();
        this.streamservices = new ArrayList<ArcGISServerServiceWrapper>();
        this.mapservices = new ArrayList<ArcGISServerServiceWrapper>();
    }

    public ArcGISServerFolderWrapper(ArcGISServerConnection connection, String folderPath, boolean includeMapService) {
        Map<String, JsonNode> map;
        Map<String, JsonNode> streamServiceDetails;
        this.name = folderPath;
        this.services = new ArrayList<ArcGISServerServiceWrapper>();
        this.streamservices = new ArrayList<ArcGISServerServiceWrapper>();
        this.mapservices = new ArrayList<ArcGISServerServiceWrapper>();
        Map<String, JsonNode> featureServiceDetails = connection.getServiceDetails(folderPath, ArcGISServerType.FeatureServer);
        if (featureServiceDetails != null) {
            for (Map.Entry<String, JsonNode> entry : connection.getServiceDetails(folderPath, ArcGISServerType.FeatureServer).entrySet()) {
                this.services.add(new ArcGISServerServiceWrapper(connection, folderPath, entry.getKey(), entry.getValue(), ArcGISServerType.FeatureServer));
            }
        }
        if ((streamServiceDetails = connection.getServiceDetails(folderPath, ArcGISServerType.StreamServer)) != null) {
            for (Map.Entry<String, JsonNode> entry : connection.getServiceDetails(folderPath, ArcGISServerType.StreamServer).entrySet()) {
                this.streamservices.add(new ArcGISServerServiceWrapper(connection, folderPath, entry.getKey(), entry.getValue(), ArcGISServerType.StreamServer));
            }
        }
        if (includeMapService && (map = connection.getServiceDetails(folderPath, ArcGISServerType.MapServer)) != null) {
            for (Map.Entry<String, JsonNode> entry : connection.getServiceDetails(folderPath, ArcGISServerType.MapServer).entrySet()) {
                this.mapservices.add(new ArcGISServerServiceWrapper(connection, folderPath, entry.getKey(), entry.getValue(), ArcGISServerType.MapServer));
            }
        }
    }

    @XmlElement(name="name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="label", required=false)
    @JsonProperty(value="label")
    public String getlabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlElementWrapper(name="services")
    @XmlElement(name="service")
    @JsonProperty(value="services")
    public List<ArcGISServerServiceWrapper> getServices() {
        return this.services;
    }

    public void setServices(List<ArcGISServerServiceWrapper> services) {
        this.services = services == null || services.size() == 0 ? null : services;
    }

    @XmlElementWrapper(name="streamservices")
    @XmlElement(name="streamservices")
    @JsonProperty(value="streamservices")
    public List<ArcGISServerServiceWrapper> getStreamServices() {
        return this.streamservices;
    }

    public void setStreamServices(List<ArcGISServerServiceWrapper> streamservices) {
        this.streamservices = streamservices == null || streamservices.size() == 0 ? null : streamservices;
    }

    @XmlElementWrapper(name="mapservices")
    @XmlElement(name="mapservice")
    @JsonProperty(value="mapservices")
    public List<ArcGISServerServiceWrapper> getMapservices() {
        return this.mapservices;
    }

    public void setMapservices(List<ArcGISServerServiceWrapper> mapservices) {
        this.mapservices = mapservices == null || mapservices.size() == 0 ? null : mapservices;
    }
}

