/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.jaxb.connector;

import com.esri.ges.connector.Connector;
import com.esri.ges.connector.ConnectorProperty;
import com.esri.ges.connector.ConnectorPropertyList;
import com.esri.ges.core.AccessType;
import com.esri.ges.core.Uri;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.jaxb.connector.AdapterUriWrapper;
import com.esri.ges.jaxb.connector.ConnectorPropertyListWrapper;
import com.esri.ges.jaxb.connector.ConnectorPropertyWrapper;
import com.esri.ges.jaxb.connector.TransportUriWrapper;
import com.esri.ges.stream.StreamType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_LBL}", description="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_DESC}")
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="connectorDefinition")
public class ConnectorWrapper {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(ConnectorWrapper.class);
    private static final String ADAPTER_PROP_NAME = "adapter";
    private static final String DEFNAME_PROP_NAME = "defaultName";
    private static final String DESC_PROP_NAME = "description";
    private static final String PROPS_PROP_NAME = "properties";
    private static final String TRANSPORT_PROP_NAME = "transport";
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_NAME_SAMPLE}")
    private String name;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_DEFAULT_NAME_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_DEFAULT_NAME_SAMPLE}")
    private String defaultName;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_TYPE_SAMPLE}", allowableValues="inbound,outbound")
    private StreamType type;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_ADAPTER_LBL}", required=true)
    private Uri adapter;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_TRANSPORT_LBL}", required=true)
    private Uri transport;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_LABEL_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_LABEL_SAMPLE}")
    private String label;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_DESCRIPTION_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_DESCRIPTION_SAMPLE}")
    private String description;
    private String sourceFile;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_PROPERTIES_LBL}", required=true)
    private ConnectorPropertyListWrapper properties;
    @ApiModelProperty(value="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_ACCESS_TYPE_LBL}", required=true, example="${com.esri.ges.rest.cxf-swagger.CONNECTOR_MODEL_ACCESS_TYPE_SAMPLE}", allowableValues="editable,nonDeletable,readOnly")
    private AccessType accessType = AccessType.editable;

    public ConnectorWrapper() {
        this.properties = new ConnectorPropertyListWrapper();
    }

    public ConnectorWrapper(Connector connector) {
        this.name = connector.getName();
        this.defaultName = connector.getDefaultName();
        String type = connector.getType().toString();
        if (StreamType.INBOUND.toString().equalsIgnoreCase(type)) {
            this.type = StreamType.INBOUND;
        } else if (StreamType.OUTBOUND.toString().equalsIgnoreCase(type)) {
            this.type = StreamType.OUTBOUND;
        }
        this.adapter = connector.getAdapterUri();
        this.transport = connector.getTransportUri();
        this.label = connector.getLabel();
        this.description = connector.getDescription();
        this.accessType = connector.getAccessType();
        ConnectorPropertyList props = connector.getProperties();
        this.properties = new ConnectorPropertyListWrapper();
        this.properties.setAdvanced(this.convertList(props.getAdvanced()));
        this.properties.setHidden(this.convertList(props.getHidden()));
        this.properties.setShown(this.convertList(props.getShown()));
    }

    private List<ConnectorPropertyWrapper> convertList(List<ConnectorProperty> shown) {
        ArrayList<ConnectorPropertyWrapper> out = new ArrayList<ConnectorPropertyWrapper>();
        for (ConnectorProperty prop : shown) {
            out.add(new ConnectorPropertyWrapper(prop));
        }
        return out;
    }

    public boolean matches(String regex) {
        if (this.name.matches(regex)) {
            return true;
        }
        if (this.defaultName != null && this.defaultName.matches(regex)) {
            return true;
        }
        if (this.label != null && this.label.matches(regex)) {
            return true;
        }
        if (this.description != null && this.description.matches(regex)) {
            return true;
        }
        if (this.type != null && this.type.toString().matches(regex)) {
            return true;
        }
        if (this.accessType != null && this.accessType.toString().matches(regex)) {
            return true;
        }
        if (this.containsMatchingProperty(this.properties.getShown(), regex)) {
            return true;
        }
        if (this.containsMatchingProperty(this.properties.getAdvanced(), regex)) {
            return true;
        }
        return this.containsMatchingProperty(this.properties.getHidden(), regex);
    }

    private boolean containsMatchingProperty(List<ConnectorPropertyWrapper> propList, String regex) {
        if (propList == null) {
            return false;
        }
        for (ConnectorPropertyWrapper prop : propList) {
            if (prop.getLabel() != null && prop.getLabel().matches(regex)) {
                return true;
            }
            if (prop.getName() == null || !prop.getName().matches(regex)) continue;
            return true;
        }
        return false;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getType() {
        return this.type.toString();
    }

    public void setType(String type) {
        if (StreamType.INBOUND.toString().equalsIgnoreCase(type)) {
            this.type = StreamType.INBOUND;
        } else if (StreamType.OUTBOUND.toString().equalsIgnoreCase(type)) {
            this.type = StreamType.OUTBOUND;
        } else {
            LOGGER.error("INVALID_CONNECTOR_TYPE", type);
        }
    }

    @XmlElement(name="adapter")
    @JsonProperty(value="adapter")
    public AdapterUriWrapper getAdapter() {
        AdapterUriWrapper wrapper = new AdapterUriWrapper();
        wrapper.setUri(this.adapter.toString());
        return wrapper;
    }

    public void setAdapter(AdapterUriWrapper adapter) {
        this.adapter = Uri.parse(adapter.getUri());
    }

    @XmlElement(name="transport")
    @JsonProperty(value="transport")
    public TransportUriWrapper getTransport() {
        TransportUriWrapper wrapper = new TransportUriWrapper();
        wrapper.setUri(this.transport.toString());
        return wrapper;
    }

    public void setTransport(TransportUriWrapper transport) {
        this.transport = Uri.parse(transport.getUri());
    }

    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlElement(name="description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="properties")
    @JsonProperty(value="properties")
    public ConnectorPropertyListWrapper getProperties() {
        return this.properties;
    }

    public void setProperties(ConnectorPropertyListWrapper properties) {
        this.properties = properties;
    }

    public void setSourceFile(String canonicalPath) {
        this.sourceFile = canonicalPath;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    @XmlElement(name="defaultName")
    @JsonProperty(value="defaultName")
    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    @XmlAttribute
    public String getAccessType() {
        return this.accessType.toString();
    }

    public void setAccessType(String accessTypeStr) {
        AccessType accessType = AccessType.getAccessType(accessTypeStr);
        if (accessType == AccessType.unknown) {
            LOGGER.warn("INVALID_ACCESS_TYPE", new Object[]{accessTypeStr, AccessType.editable});
            this.accessType = AccessType.editable;
        } else {
            this.accessType = accessType;
        }
    }

    public Connector convert() {
        Connector.ConnectorType connectorType = Connector.ConnectorType.inbound;
        connectorType = this.type == StreamType.INBOUND ? Connector.ConnectorType.inbound : Connector.ConnectorType.outbound;
        Connector connector = new Connector(this.name, this.defaultName, connectorType, this.adapter, this.transport, this.label, this.description, this.accessType);
        for (ConnectorPropertyWrapper propertyWrapper : this.properties.getShown()) {
            connector.addShownProperty(new ConnectorProperty(ConnectorProperty.Source.valueOf(propertyWrapper.getSource()), propertyWrapper.getName(), propertyWrapper.getDefault(), propertyWrapper.getLabel()));
        }
        for (ConnectorPropertyWrapper propertyWrapper : this.properties.getHidden()) {
            connector.addHiddenProperty(new ConnectorProperty(ConnectorProperty.Source.valueOf(propertyWrapper.getSource()), propertyWrapper.getName(), propertyWrapper.getDefault(), propertyWrapper.getLabel()));
        }
        for (ConnectorPropertyWrapper propertyWrapper : this.properties.getAdvanced()) {
            connector.addAdvancedProperty(new ConnectorProperty(ConnectorProperty.Source.valueOf(propertyWrapper.getSource()), propertyWrapper.getName(), propertyWrapper.getDefault(), propertyWrapper.getLabel()));
        }
        return connector;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConnectorWrapper)) {
            return false;
        }
        ConnectorWrapper connector = (ConnectorWrapper)obj;
        if (!ObjectUtils.equals((Object)this.getAccessType(), (Object)connector.getAccessType())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getAdapter(), (Object)connector.getAdapter())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getDefaultName(), (Object)connector.getDefaultName())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getDescription(), (Object)connector.getDescription())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getLabel(), (Object)connector.getLabel())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getName(), (Object)connector.getName())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getProperties(), (Object)connector.getProperties())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getSourceFile(), (Object)connector.getSourceFile())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getTransport(), (Object)connector.getTransport())) {
            return false;
        }
        return ObjectUtils.equals((Object)this.getType(), (Object)connector.getType());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

