/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.framework.i18n;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class BundleResourceUtil {
    private static BundleResourceUtil instance;
    private Map<String, ResourceBundle> bundleCache = new HashMap<String, ResourceBundle>();
    private static final BundleLogger LOG;

    protected BundleResourceUtil() {
        try {
            Locale defaultLocale;
            String defaultLocaleProp = System.getProperty("GEOEVENT_DEFAULT_LOCALE");
            if (defaultLocaleProp != null && (defaultLocale = LocaleUtils.toLocale((String)defaultLocaleProp)) != null) {
                Locale.setDefault(defaultLocale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static ResourceBundle getBundle(Class<?> clazz) {
        String bundleName = BundleResourceUtil.getBundleName(clazz);
        ClassLoader bundleCL = BundleResourceUtil.getBundleClassLoader(clazz);
        return BundleResourceUtil.getInstance().getBundleImpl(bundleName, bundleCL);
    }

    protected static ResourceBundle getBundle(String bundleName) {
        return BundleResourceUtil.getInstance().getBundleImpl(bundleName);
    }

    protected static String getMessage(Class<?> clazz, String key) {
        if (clazz == null || key == null) {
            return key;
        }
        String bundleName = BundleResourceUtil.getBundleName(clazz);
        ClassLoader bundleCL = BundleResourceUtil.getBundleClassLoader(clazz);
        return BundleResourceUtil.getMessage(bundleName, key, bundleCL);
    }

    protected static String getMessage(Class<?> clazz, String key, Object ... params) {
        if (clazz == null || key == null) {
            return key;
        }
        String bundleName = BundleResourceUtil.getBundleName(clazz);
        ClassLoader bundleCL = BundleResourceUtil.getBundleClassLoader(clazz);
        return BundleResourceUtil.getMessage(bundleName, key, bundleCL, params);
    }

    protected static String getMessage(String bundleName, String key) {
        if (bundleName == null || key == null) {
            return key;
        }
        ResourceBundle bundle = BundleResourceUtil.getInstance().getBundleImpl(bundleName);
        if (bundle == null) {
            return key;
        }
        try {
            String message = bundle.getString(key);
            return message;
        }
        catch (Exception ignored) {
            return key;
        }
    }

    protected static String getMessage(String bundleName, String key, ClassLoader bundleCL) {
        if (bundleName == null || key == null) {
            return key;
        }
        ResourceBundle bundle = BundleResourceUtil.getInstance().getBundleImpl(bundleName, bundleCL);
        if (bundle == null) {
            return key;
        }
        try {
            String message = bundle.getString(key);
            return message;
        }
        catch (Exception ignored) {
            return key;
        }
    }

    protected static String getMessage(String bundleName, String key, Object ... params) {
        if (bundleName == null || key == null) {
            return key;
        }
        String message = BundleResourceUtil.getMessage(bundleName, key);
        if (message == null) {
            return key;
        }
        return BundleResourceUtil.formatMessage(message, params);
    }

    protected static String getMessage(String bundleName, String key, ClassLoader bundleCL, Object ... params) {
        if (bundleName == null || key == null) {
            return key;
        }
        String message = BundleResourceUtil.getMessage(bundleName, key, bundleCL);
        if (message == null) {
            return key;
        }
        return BundleResourceUtil.formatMessage(message, params);
    }

    public static String translate(String value) {
        if (value == null) {
            return value;
        }
        StrSubstitutor subs = new StrSubstitutor((StrLookup)new StrLookup<String>(){

            public String lookup(String placeholderName) {
                String key;
                String bundleName;
                if (placeholderName == null) {
                    return placeholderName;
                }
                String msg = null;
                int endIndex = placeholderName.lastIndexOf(".");
                if (endIndex != -1 && ((msg = BundleResourceUtil.getMessage(bundleName = placeholderName.substring(0, endIndex), key = placeholderName.substring(endIndex + 1))) == null || msg.equals(key))) {
                    ClassLoader bundleCL = BundleResourceUtil.getBundleClassLoader(bundleName);
                    msg = BundleResourceUtil.getMessage(bundleName, key, bundleCL);
                    if (msg == null || msg.equals(key)) {
                        return null;
                    }
                    return msg;
                }
                return msg;
            }
        });
        return subs.replace(value);
    }

    private static BundleResourceUtil getInstance() {
        if (instance == null) {
            instance = new BundleResourceUtil();
        }
        return instance;
    }

    private ResourceBundle getBundleImpl(String bundleName, ClassLoader bundleCL) {
        Locale locale = Locale.getDefault();
        String key = bundleName + ":" + locale.toString();
        if (this.bundleCache.containsKey(key)) {
            return this.bundleCache.get(key);
        }
        ResourceBundle bundle = this.loadBundleSwitchCL(bundleName);
        if (bundle == null && (bundle = this.loadBundleCurrentCL(bundleName)) == null) {
            bundle = this.loadBundleFromItsCL(bundleName, bundleCL);
        }
        if (bundle != null) {
            this.bundleCache.put(key, bundle);
        } else {
            LOG.debug("FAILED_TO_LOAD_BUNDLE", bundleName);
        }
        return bundle;
    }

    private ResourceBundle getBundleImpl(String bundleName) {
        Locale locale = Locale.getDefault();
        String key = bundleName + ":" + locale.toString();
        if (this.bundleCache.containsKey(key)) {
            return this.bundleCache.get(key);
        }
        ResourceBundle bundle = this.loadBundleSwitchCL(bundleName);
        if (bundle == null) {
            bundle = this.loadBundleCurrentCL(bundleName);
        }
        if (bundle != null) {
            this.bundleCache.put(key, bundle);
        } else {
            LOG.debug("FAILED_TO_LOAD_BUNDLE", bundleName);
        }
        return bundle;
    }

    private ResourceBundle loadBundleFromItsCL(String bundleName, ClassLoader bundleCL) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), bundleCL);
        }
        catch (Throwable exception) {
            LOG.trace("FAILED_TO_LOAD_BUNDLE_OWN_CL", exception, bundleName);
        }
        return bundle;
    }

    private ResourceBundle loadBundleSwitchCL(String bundleName) {
        ResourceBundle bundle = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(BundleResourceUtil.class.getClassLoader());
            bundle = ResourceBundle.getBundle(bundleName);
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable exception) {
            LOG.trace("FAILED_TO_LOAD_BUNDLE_SWITCH_CL", exception, bundleName, BundleResourceUtil.class.getName());
        }
        return bundle;
    }

    private ResourceBundle loadBundleCurrentCL(String bundleName) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(bundleName);
        }
        catch (Throwable exception) {
            LOG.trace("FAILED_TO_LOAD_BUNDLE", exception, bundleName);
        }
        return bundle;
    }

    private static String getBundleName(Class<?> clazz) {
        Bundle osgiBundle = FrameworkUtil.getBundle(clazz);
        if (osgiBundle == null) {
            return null;
        }
        if (osgiBundle.getSymbolicName() == null) {
            return null;
        }
        return osgiBundle.getSymbolicName();
    }

    private static ClassLoader getBundleClassLoader(Class<?> clazz) {
        Bundle osgiBundle = FrameworkUtil.getBundle(clazz);
        if (osgiBundle == null) {
            return null;
        }
        if (osgiBundle.getSymbolicName() == null) {
            return null;
        }
        return osgiBundle.getClass().getClassLoader();
    }

    private static ClassLoader getBundleClassLoader(String symbolicName) {
        try {
            Bundle[] allBundles;
            for (Bundle currentBundle : allBundles = FrameworkUtil.getBundle(BundleResourceUtil.class).getBundleContext().getBundles()) {
                if (!currentBundle.getSymbolicName().equalsIgnoreCase(symbolicName)) continue;
                return ((BundleWiring)currentBundle.adapt(BundleWiring.class)).getClassLoader();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String formatMessage(String message, Object ... params) {
        String formattedString = null;
        try {
            formattedString = MessageFormat.format(message, params);
        }
        catch (Throwable t) {
            formattedString = message;
        }
        return BundleResourceUtil.translate(formattedString);
    }

    static {
        LOG = BundleLoggerFactory.getLogger(BundleResourceUtil.class);
    }
}

