/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.framework.i18n;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleResourceUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.logging.log4j2.appender.GeoEventPatternThreadLocalMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleLoggerImpl
implements BundleLogger {
    private final String bundleSymbolicName;
    private final Log log;
    private Bundle osgiBundle;

    public BundleLoggerImpl(Class<?> clazz) {
        this.log = LogFactory.getLog(clazz);
        this.bundleSymbolicName = this.getBundleSymbolicName(clazz);
    }

    public BundleLoggerImpl(Class<?> clazz, String loggerName) {
        this.log = LogFactory.getLog((String)loggerName);
        this.bundleSymbolicName = this.getBundleSymbolicName(clazz);
    }

    public BundleLoggerImpl(String loggerName, String bundleSymbolicName) {
        this.log = LogFactory.getLog((String)loggerName);
        this.bundleSymbolicName = bundleSymbolicName;
    }

    private String getBundleSymbolicName(Class<?> clazz) {
        this.osgiBundle = FrameworkUtil.getBundle(clazz);
        if (this.osgiBundle == null) {
            return null;
        }
        if (this.osgiBundle.getSymbolicName() == null) {
            return null;
        }
        return this.osgiBundle.getSymbolicName();
    }

    private void setDelegateContext() {
        if (this.osgiBundle != null) {
            this.put("geoeventBundleID", new Long(this.osgiBundle.getBundleId()));
            this.put("geoeventBundleName", this.osgiBundle.getSymbolicName());
            this.put("geoeventBundleVersion", this.osgiBundle.getHeaders().get("Bundle-Version"));
        }
    }

    private void clearDelegateContext() {
        GeoEventPatternThreadLocalMap.clear();
    }

    private void put(String name, Object o) {
        if (o != null) {
            GeoEventPatternThreadLocalMap.put(name, o.toString());
        }
    }

    @Override
    public void trace(String key) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.log.trace((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void trace(String key, Object ... args) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.log.trace((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void trace(String key, Throwable t) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.log.trace((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void trace(String key, Throwable t, Object ... args) {
        if (this.isTraceEnabled()) {
            this.setDelegateContext();
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.log.trace((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void debug(String key) {
        if (this.isDebugEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.debug((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void debug(String key, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.debug((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void debug(String key, Throwable t) {
        if (this.isDebugEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.debug((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void debug(String key, Throwable t, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.debug((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void info(String key) {
        if (this.isInfoEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.info((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void info(String key, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.info((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void info(String key, Throwable t) {
        if (this.isInfoEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.info((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void info(String key, Throwable t, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.info((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void warn(String key) {
        if (this.isWarnEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.warn((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void warn(String key, Object ... args) {
        if (this.isWarnEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.warn((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void warn(String key, Throwable t) {
        if (this.isWarnEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.warn((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void warn(String key, Throwable t, Object ... args) {
        if (this.isWarnEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.warn((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void error(String key) {
        if (this.isErrorEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.error((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void error(String key, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.error((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void error(String key, Throwable t) {
        if (this.isErrorEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.error((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void error(String key, Throwable t, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.error((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void fatal(String key) {
        if (this.isFatalEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.fatal((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void fatal(String key, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.fatal((Object)msg);
            this.clearDelegateContext();
        }
    }

    @Override
    public void fatal(String key, Throwable t) {
        if (this.isFatalEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
            this.setDelegateContext();
            this.log.fatal((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public void fatal(String key, Throwable t, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
            this.setDelegateContext();
            this.log.fatal((Object)msg, t);
            this.clearDelegateContext();
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public String translate(String key) {
        return BundleResourceUtil.getMessage(this.bundleSymbolicName, key);
    }

    @Override
    public String translate(String key, Object ... args) {
        return BundleResourceUtil.getMessage(this.bundleSymbolicName, key, args);
    }
}

