/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.framework.i18n;

import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerImpl;
import java.util.Hashtable;
import org.apache.commons.logging.LogConfigurationException;

public class BundleLoggerFactory {
    private static BundleLoggerFactory factory;
    private Hashtable<String, BundleLogger> instances = new Hashtable();

    protected BundleLoggerFactory() {
    }

    public static BundleLogger getLogger(Class<?> clazz) throws LogConfigurationException {
        return BundleLoggerFactory.getFactory().getInstance(clazz);
    }

    public static BundleLogger getLogger(String loggerName, String bundleSymbolicName) throws LogConfigurationException {
        return BundleLoggerFactory.getFactory().getInstance(loggerName, bundleSymbolicName);
    }

    public static BundleLogger getLogger(Class<?> clazz, String loggerName) throws LogConfigurationException {
        return BundleLoggerFactory.getFactory().getInstance(clazz, loggerName);
    }

    private static BundleLoggerFactory getFactory() {
        if (factory == null) {
            factory = new BundleLoggerFactory();
        }
        return factory;
    }

    private BundleLogger getInstance(Class<?> clazz) throws LogConfigurationException {
        BundleLogger instance = this.instances.get(clazz.getName());
        if (instance == null) {
            instance = this.newInstance(clazz);
            this.instances.put(clazz.getName(), instance);
        }
        return instance;
    }

    private BundleLogger getInstance(String loggerName, String bundleSymbolicName) throws LogConfigurationException {
        BundleLogger instance = this.instances.get(loggerName);
        if (instance == null) {
            instance = this.newInstance(loggerName, bundleSymbolicName);
            this.instances.put(loggerName, instance);
        }
        return instance;
    }

    private BundleLogger getInstance(Class<?> clazz, String loggerName) throws LogConfigurationException {
        BundleLogger instance = this.instances.get(loggerName);
        if (instance == null) {
            instance = this.newInstance(clazz, loggerName);
            this.instances.put(loggerName, instance);
        }
        return instance;
    }

    private BundleLogger newInstance(Class<?> clazz) throws LogConfigurationException {
        BundleLoggerImpl instance = null;
        try {
            instance = new BundleLoggerImpl(clazz);
            return instance;
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }

    private BundleLogger newInstance(String loggerName, String bundleSymbolicName) throws LogConfigurationException {
        BundleLoggerImpl instance = null;
        try {
            instance = new BundleLoggerImpl(loggerName, bundleSymbolicName);
            return instance;
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }

    private BundleLogger newInstance(Class<?> clazz, String loggerName) throws LogConfigurationException {
        BundleLoggerImpl instance = null;
        try {
            instance = new BundleLoggerImpl(clazz, loggerName);
            return instance;
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }
}

