/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.datastore.folder;

import com.esri.ges.core.AccessType;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.datastore.DefaultDataStore;
import com.esri.ges.datastore.folder.FolderDataStore;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import java.io.File;

public class DefaultFolderDataStore
extends DefaultDataStore
implements FolderDataStore {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(DefaultFolderDataStore.class);
    private File path;
    private String status;
    private boolean exists = false;
    private boolean canRead = false;
    private boolean canWrite = false;

    public DefaultFolderDataStore(String name, String label, File path) {
        this.setName(name);
        this.setLabel(label);
        this.setPath(path);
    }

    public DefaultFolderDataStore(String name, String label, File path, String accessType) {
        this(name, label, path);
        this.setAccessType(AccessType.valueOf(accessType));
    }

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
        try {
            this.validate();
        }
        catch (ValidationException e) {
            LOGGER.error("FOLDER_DS_VALIDATION_FAILED", e.getMessage());
        }
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public boolean isCanRead() {
        return this.canRead;
    }

    @Override
    public boolean isCanWrite() {
        return this.canWrite;
    }

    @Override
    public boolean isExists() {
        return this.exists;
    }

    @Override
    public void onShutdown() {
        LOGGER.info("FOLDER_DS_SHUTDOWN", this.getName());
    }

    private boolean canWrite() {
        try {
            File.createTempFile(".gep-", null, this.path).delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean canRead() {
        return this.path.listFiles() != null;
    }

    @Override
    public void validate() throws ValidationException {
        this.status = "";
        this.exists = false;
        this.canRead = false;
        this.canWrite = false;
        if (this.path == null) {
            this.status = LOGGER.translate("FOLDER_DS_PATH_NULL");
        } else {
            try {
                if (this.path.isDirectory()) {
                    this.exists = true;
                    this.canRead = this.canRead();
                    this.canWrite = this.canWrite();
                } else {
                    this.status = LOGGER.translate("FOLDER_DS_PATH_DOESNT_EXIST");
                }
            }
            catch (SecurityException e) {
                this.status = e.getMessage();
            }
        }
        if (!this.status.isEmpty()) {
            throw new ValidationException(this.status);
        }
    }
}

