/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.property;

import com.esri.ges.core.property.Property;
import com.esri.ges.core.property.PropertyCollection;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.core.property.PropertyException;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.core.security.GeoEventServerCryptoService;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PropertyCollectionBase
extends Observable
implements PropertyCollection {
    protected Map<String, Property> properties = new ConcurrentHashMap<String, Property>();
    protected GeoEventServerCryptoService cryptoService;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(PropertyCollectionBase.class);

    @Override
    public void setCryptoService(GeoEventServerCryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    @Override
    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    @Override
    public void setProperties(Collection<Property> properties) throws PropertyException {
        List<String> errors = this.installProperties(properties);
        if (!errors.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String message : errors) {
                sb.append(message).append("\n");
            }
            throw new PropertyException(LOGGER.translate("PROPERTY_COLLECTION_FAILED_TO_SET", this.getClass().getName(), sb.toString()));
        }
        this.afterPropertiesSet();
    }

    private synchronized List<String> installProperties(Collection<Property> properties) throws PropertyException {
        ArrayList<String> errors = new ArrayList<String>();
        if (properties != null) {
            for (Property property : properties) {
                try {
                    this.setProperty(property);
                }
                catch (PropertyException e) {
                    errors.add(e.getMessage());
                }
            }
        }
        return errors;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public Property getProperty(String name) {
        Property prop = this.properties.get(name);
        if (prop.getDefinition().getType() == PropertyType.Password) {
            prop.setCryptoService(this.cryptoService);
        }
        return prop;
    }

    @Override
    public synchronized void setProperty(Property property) throws PropertyException {
        if (property == null) {
            throw new PropertyException(LOGGER.translate("PROPERTY_COLLECTION_PROP_NULL", this.getClass().getName()));
        }
        String propName = property.getName();
        PropertyDefinition pd = property.getDefinition();
        if (pd.isReadOnly()) {
            if (!property.equals(property.getDefinition().getDefaultProperty())) {
                throw new PropertyException(LOGGER.translate("PROPERTY_COLLECTION_PROP_READONLY", propName, this.getClass().getName()));
            }
        } else {
            if (this.hasProperty(propName)) {
                this.properties.remove(propName);
            }
            this.properties.put(propName, property);
            this.afterPropertySet(propName);
        }
    }

    @Override
    public synchronized void deleteProperty(String name) {
        if (this.hasProperty(name)) {
            this.properties.remove(name);
        }
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public void afterPropertySet(String propName) {
    }

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public void notifyObservers(Object event) {
        if (event != null) {
            this.setChanged();
            super.notifyObservers(event);
            this.clearChanged();
        }
    }

    @Override
    public void validate() throws ValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        for (Property property : this.properties.values()) {
            try {
                String dependsOn = Validator.compactWhiteSpaces(property.getDefinition().getDependsOn()).trim();
                if (dependsOn.isEmpty()) {
                    property.validate();
                    continue;
                }
                LinkedList<String> tokens = new LinkedList<String>();
                StringTokenizer st = new StringTokenizer(dependsOn, ",");
                while (st.hasMoreTokens()) {
                    tokens.add(st.nextToken());
                }
                block4: while (!tokens.isEmpty()) {
                    String token;
                    String propertyName = token = ((String)tokens.poll()).trim();
                    String propertyValue = "";
                    int i = token.indexOf("=");
                    if (i != -1) {
                        propertyName = token.substring(0, i).trim();
                        propertyValue = token.substring(i + 1).trim();
                    }
                    for (String name : this.properties.keySet()) {
                        if (!name.equalsIgnoreCase(propertyName)) continue;
                        if (!propertyValue.isEmpty() && !propertyValue.equalsIgnoreCase(this.properties.get(propertyName).getValueAsString())) continue block4;
                        property.validate();
                        continue block4;
                    }
                }
            }
            catch (ValidationException e) {
                errors.add(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String message : errors) {
                sb.append(message).append("\n");
            }
            throw new ValidationException(sb.toString());
        }
    }
}

