/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.property;

import com.esri.ges.core.property.LabeledValue;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.core.property.PropertyException;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.core.security.GeoEventServerCryptoService;
import com.esri.ges.core.validation.Validatable;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Property
implements Validatable {
    private PropertyDefinition definition;
    private Object value;
    private GeoEventServerCryptoService cryptoService;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(Property.class);

    public Property() {
    }

    public Property(PropertyDefinition definition) throws PropertyException {
        if (definition == null) {
            throw new PropertyException(LOGGER.translate("PROPERTY_DEF_NULL"));
        }
        this.definition = definition;
        this.value = definition.getDefaultValue();
    }

    public Property(PropertyDefinition definition, Object value) throws PropertyException {
        this(definition);
        this.setValue(value);
    }

    public void setCryptoService(GeoEventServerCryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(PropertyDefinition definition) {
        this.definition = definition;
    }

    public String getName() {
        return this.definition.getPropertyName();
    }

    public String getDisplayName() {
        return this.definition.getLabel();
    }

    public PropertyType getType() {
        return this.definition.getType();
    }

    public boolean isMandatory() {
        return this.definition.isMandatory();
    }

    public boolean isReadOnly() {
        return this.definition.isReadOnly();
    }

    public boolean isValid() {
        return this.definition.isMandatory() ? this.value != null : true;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return this.value != null ? this.value.toString().trim() : "";
    }

    public String getDecryptedValue() throws Exception {
        if (this.value != null && this.value.toString().length() > 0) {
            return this.cryptoService.decrypt(this.value.toString());
        }
        return "";
    }

    public void setValue(Object value) {
        this.value = this.definition.validateValue(value);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Property && this.definition.equals(((Property)obj).getDefinition()) && (this.value == null && ((Property)obj).getValue() == null || this.value != null && ((Property)obj).getValue() != null && this.value.equals(((Property)obj).getValue()));
    }

    @Override
    public synchronized void validate() throws ValidationException {
        if (this.value == null || this.value.toString().isEmpty()) {
            if (this.definition.isMandatory()) {
                throw new ValidationException(LOGGER.translate("PROPERTY_REQUIRED_PROP", this.definition.getPropertyName()));
            }
        } else if (!this.definition.getAllowedValues().isEmpty()) {
            LabeledValue matchedValue = null;
            for (LabeledValue allowedValue : this.definition.getAllowedValues()) {
                if (!allowedValue.getValue().equals(this.value)) continue;
                matchedValue = allowedValue;
                break;
            }
            if (matchedValue == null) {
                throw new ValidationException(LOGGER.translate("PROPERTY_INVALID_ALLOWED_VALUE", this.definition.getPropertyName()));
            }
        }
        if (!Validator.isValidPropertyName(this.definition.getPropertyName())) {
            throw new ValidationException(LOGGER.translate("PROPERTY_INVALID_NAME", this.definition.getPropertyName()));
        }
    }

    public void toXml(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter != null) {
            xmlWriter.writeStartElement("property");
            xmlWriter.writeAttribute("name", Validator.compactSpaces(this.getName()));
            xmlWriter.writeCharacters(Converter.escapeXmlForBrowser(this.getValueAsString()));
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(writer);
            this.toXml(xmlWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }
}

